#include<stdio.h>
#include<stdlib.h>

#include "jsocket6.h"

#define MAX_CLIENTS 3
#define PORT 6666
#define MAX_SIZE 256

int main() {
  int s, i;
  int cliente[MAX_CLIENTS];
  fd_set mask;
  int cnt;
  char buf[MAX_SIZE];


  for (i=0;i<MAX_CLIENTS;i++) 
    cliente[i] = -1;

  s = j_socket();

  if(j_bind(s,PORT) < 0) {
    fprintf(stderr,"No pude tomar la puerta\n");
    exit(1);
  }

  for(;;) {

    FD_ZERO(&mask);
    FD_SET(s,&mask);

    for (i=0;i < MAX_CLIENTS;i++) 
      if (cliente[i] != -1)
	FD_SET(cliente[i],&mask);

    if (select(getdtablesize(),&mask,NULL,NULL,NULL) < 0) {
      fprintf(stderr,"Error en select\n");
      exit(1);
    }

    for (i=0;i<MAX_CLIENTS;i++) {
      if (cliente[i] != -1 && FD_ISSET(cliente[i],&mask)) 
	if ((cnt=read(cliente[i],buf,MAX_SIZE)) > 0)
	    write(cliente[i],buf,cnt);
	else {
	  fprintf(stderr,"El cliente murio %d\n",cnt);
	  close(cliente[i]);
	  cliente[i] = -1;
	}
    }

    if (FD_ISSET(s,&mask)) {
      /* debo encontrar un cliente vacio para el accept */
      for (i=0;i<MAX_CLIENTS;i++) 
	if (cliente[i] == -1) break;

      if (i == MAX_CLIENTS) {
	close(j_accept(s));
	continue;
      }
      
      cliente[i] = j_accept(s);
	printf("LLEGO UN CLIENTE\n");
    } 
  }

}
