#include<stdio.h>
#include<stdlib.h>
#include<signal.h>
#include<wait.h>

#include "jsocket6.h"

#define BUFFER_SIZE 100
#define PORT 6666

#define MAX_CLIENTS 3

int clientes = 0;

void child() {
  int status;

  while(waitpid(-1,&status,WNOHANG)>0);

  clientes--;
  
}

void servir(int ss) {
  int cnt;
  char buf[BUFFER_SIZE];
  
  
  while((cnt=read(ss,buf,BUFFER_SIZE)) > 0) {
    write(ss,buf,cnt);
    write(1,buf,cnt);

    if (strncmp(buf,"quit",4) == 0)
      break;
  }

  close(ss);
}

int main() {
  int s, s2;

  signal(SIGCHLD,child);

  s = j_socket();

  if(j_bind(s, PORT) < 0) {
    fprintf(stderr,"Fallo el bind del port %d\n", PORT);
    exit(1);
  }

  for (;;) {
    if ((s2 = j_accept(s)) < 0) {
      /* Aqui hay un Bug a corregir */
      fprintf(stderr,"Error en el socket al accept\n");
      close(s2);
      continue;
    }
    
    if (clientes >= MAX_CLIENTS) {
      write(s2,"Lo siento, maximo alcanzado, chao\n",37);
      close(s2);
      continue;
    }

    clientes++;

    printf("Alguien se conecto\n");
    
    if (fork() == 0) {
      /*soy el hijo */
      close(s); /* Produce un error, a revisar */
      servir(s2);
      exit(0);
    } else {
      close(s2);
    }    
  }
  close(s);
}
