#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <signal.h>

#include "jsocket6.h"

#define MAX_BUFFER 256

void proxy(int s, char *host, int port) {
  int ss, cnt;
  char buf[MAX_BUFFER];
  int pid;

  ss = j_socket();

  printf("Connectando con server %s/%d\n",host,port);

  if(j_connect(ss,host,port) < 0) {
    fprintf(stderr,"Cannot connect to server %s/%d\n",host,port);
    return;
  }

  if ((pid = fork()) == 0) {
    /* rehijo */
    while((cnt =read(s,buf,MAX_BUFFER)) > 0 && write(ss,buf,cnt) > 0);
    kill(getppid(), SIGKILL);
    exit(1);
  } else {
    /* pseudo padre */
    while((cnt =read(ss,buf,MAX_BUFFER)) > 0 && write(s,buf,cnt) > 0);
    kill(pid, SIGKILL);
    exit(1);
  }

  return;
}

int main(int argc, char *argv[]) {
  char *server, *sport, *sclient_port;
  int s, s2, port, client_port;


  if (argc != 4) {
    printf("Use proxy <servidor> <puerto> <puerto_cliente>\n");
    exit(1);
  }

  server = argv[1];
  sport = argv[2];
  sclient_port = argv[3];

  port = atoi(sport);
  client_port = atoi(sclient_port);


  s = j_socket();

  if (j_bind(s,client_port) < 0){
    fprintf(stderr,"Cannot bind on port %s\n",sport);
    exit(-1);
  }

  for (;;) {

    if ((s2 = j_accept(s))<0) {
      fprintf(stderr,"Error al accept\n");
      exit(1);
    }
    
    if (fork() == 0) {
      /* hijo */
      close(s);
      proxy(s2, server,port);
      exit(0);
    } else {
      close(s2);
    }
  }

}
