#include "tbox-mon.h"
#include<stdlib.h>
#include<stdio.h>

ALMACEN *crea_almacen() {
  ALMACEN *r = (ALMACEN *)malloc(sizeof(ALMACEN));
  r->in = r->out = 0;
  pthread_mutex_init(&r->mutex,NULL);
  pthread_cond_init(&r->vacios,NULL);
  pthread_cond_init(&r->llenos,NULL);

  r->nvacios = NBUFS; r->nllenos = 0;

  return(r);
}

void print_almacen(ALMACEN *a) {
  int i;
  for (i=a->out;i!=a->in;i = (i+1)%NBUFS) 
    printf("%d->",a->buf[i]);
  printf("\n");
}

void pon_en_almacen(ALMACEN *a, int c) {


  pthread_mutex_lock(&a->mutex);

  while (a->nvacios == 0)
    pthread_cond_wait(&a->vacios, &a->mutex);

  a->buf[a->in] = c;
  a->in = (a->in+1)%NBUFS;

  a->nllenos++; a->nvacios--;
  pthread_cond_signal(&a->llenos);
  pthread_mutex_unlock(&a->mutex);

}

int toma_del_almacen(ALMACEN *a) {
  int c;

  pthread_mutex_lock(&a->mutex);

  while (a->nllenos == 0)
    pthread_cond_wait(&a->llenos, &a->mutex);

  c = a->buf[a->out];
  a->buf[a->out] = -1;
  a->out = (a->out+1)%NBUFS;

  a->nllenos--; a->nvacios++;
  pthread_cond_signal(&a->vacios);
  pthread_mutex_unlock(&a->mutex);

  return(c);
}
