#include "tbox-sem.h"
#include<stdlib.h>
#include<stdio.h>

ALMACEN *crea_almacen() {
  ALMACEN *r = (ALMACEN *)malloc(sizeof(ALMACEN));
  r->in = r->out = 0;

  sem_init(&r->llenos,0,NBUFS);
  sem_init(&r->vacios,0,0);

  pthread_mutex_init(&r->mprod,NULL);
  pthread_mutex_init(&r->mcons,NULL);

  return(r);
}

void print_almacen(ALMACEN *a) {
  int i;
  for (i=a->out;i!=a->in;i = (i+1)%NBUFS) 
    printf("%d->",a->buf[i]);
  printf("\n");
}

void pon_en_almacen(ALMACEN *a, int c) {

  sem_wait(&a->llenos);

  pthread_mutex_lock(&a->mprod);
  a->buf[a->in] = c;
  a->in = (a->in+1)%NBUFS;
  pthread_mutex_unlock(&a->mprod);

  sem_post(&a->vacios);
}

int toma_del_almacen(ALMACEN *a) {
  int c;

  sem_wait(&a->vacios);

  pthread_mutex_lock(&a->mcons);
  c = a->buf[a->out];
  a->buf[a->out] = -1;
  a->out = (a->out+1)%NBUFS;
  pthread_mutex_unlock(&a->mcons);

  sem_post(&a->llenos);

  return(c);
}
