import java.util.Random;

public class Imagenes {
	
	private double[][] coleccion;
	private Minkowski dist;
	private double[] distancias;

	public Imagenes() {
		coleccion = new double[500001][3];
		Random r = new Random(1);
		for (int i = 0; i < coleccion.length; i++) {
			for (int j = 0; j < coleccion[i].length; j++) {
				coleccion[i][j] = r.nextDouble() * 10;
			}
		}
		dist = null;
		distancias = null;
	}

	public int getNumeroImagenes() {
		return coleccion.length;
	}

	public double[] getVector(int idImagen) {
		return coleccion[idImagen];
	}

	public double getDistanciaConPivote(Minkowski funcDist, int idImagen) {
		if (funcDist != this.dist) {
			this.dist = funcDist;
			this.distancias = new double[getNumeroImagenes()];
			int piv = new Random(0).nextInt(distancias.length);
			for (int i = 0; i < distancias.length; i++) {
				distancias[i] = funcDist.distancia(getVector(piv), getVector(i));
			}
		}
		return distancias[idImagen];
	}

}
