public class Aux1 {

	private Imagenes ims;

	public Aux1() {
		ims = new Imagenes();
	}

	public int getNumeroImagenes() {
		return ims.getNumeroImagenes();
	}

	public double[] getVector(int idImagen) {
		return ims.getVector(idImagen);
	}

	public double getDistanciaConPivote(Minkowski funcDist, int idImagen) {
		return ims.getDistanciaConPivote(funcDist, idImagen);
	}

	// pregunta 2
	public int busquedaNN(int idImagenConsulta, Minkowski funcDist) {
		double[] vectorConsulta = getVector(idImagenConsulta);
		double minDist = Double.MAX_VALUE;
		int minId = -1;
		for (int i = 0; i < getNumeroImagenes(); i++) {
			if (i == idImagenConsulta)
				continue;
			double[] vectorImagen = getVector(i);
			double distancia = funcDist.distancia(vectorConsulta, vectorImagen);
			if (distancia < minDist) {
				minDist = distancia;
				minId = i;
			}
		}
		if (minId < 0)
			System.out.println("error, no hay imagenes!");
		System.out.println("imagen " + minId + " es la mas cercana a "
				+ idImagenConsulta + " (d=" + minDist + ")");
		return minId;
	}

	// pregunta 3
	public void busquedaRango(int idImagenConsulta, Minkowski funcDist,
			double rango) {
		double[] vectorConsulta = getVector(idImagenConsulta);
		for (int i = 0; i < getNumeroImagenes(); i++) {
			if (i == idImagenConsulta)
				continue;
			double distancia = funcDist.distancia(vectorConsulta, getVector(i));
			if (distancia <= rango)
				System.out.println("imagen " + i + " es cercana a imagen "
						+ idImagenConsulta + " (d=" + distancia + ")");
		}
	}

	// pregunta 4
	public void busquedaRangoConPivotes(int idImagenConsulta,
			Minkowski funcDist, double rango) {
		double dist_qp = getDistanciaConPivote(funcDist, idImagenConsulta);
		double[] vectorConsulta = getVector(idImagenConsulta);
		int contDistancias = 0;
		for (int i = 0; i < getNumeroImagenes(); i++) {
			if (i == idImagenConsulta)
				continue;
			double dist_px = getDistanciaConPivote(funcDist, i);
			if (Math.abs(dist_qp - dist_px) > rango)
				continue;
			contDistancias++;
			double distancia = funcDist.distancia(vectorConsulta, getVector(i));
			if (distancia <= rango)
				System.out.println("imagen " + i + " es cercana a imagen "
						+ idImagenConsulta + " (d=" + distancia + ")");
		}
		System.out.println("se calcularon solo " + contDistancias
				+ " distancias en vez de " + (getNumeroImagenes() - 1)
				+ " (un "
				+ (100.0 * contDistancias / (getNumeroImagenes() - 1)) + "%)");
	}

	public static void main(String[] args) {
		Minkowski fdist = new Minkowski(2);
		Aux1 aux1 = new Aux1();
		System.out.println("imagenes en la coleccion: "
				+ aux1.getNumeroImagenes());
		System.out.println();
		aux1.busquedaNN(10, fdist);
		System.out.println();
		aux1.busquedaRango(10, fdist, 0.12);
		System.out.println();
		aux1.busquedaRangoConPivotes(10, fdist, 0.12);
	}
}
