class TestQueue{

    
    public static void pushTest(){
        Queue q = new Queue();

        if ( q.length() != 0 ){
            System.out.println("Error largo incorrecto");
        }
        if ( !q.toString().trim().equals("") ){
            System.out.println("Representación del Queue incorrecta");
        }

        q.push(5);
        if ( q.length() != 1 ){
            System.out.println("Error largo incorrecto");
        }
        if ( !q.toString().trim().equals("5") ){
            System.out.println("Representación del Queue incorrecta");
        }
        q.push(10);
        if ( q.length() != 2 ){
            System.out.println("Error largo incorrecto");
        }
        if ( !q.toString().trim().equals("5 10") ){
            System.out.println("Representación del Queue incorrecta");
        }
        q.push(20);
        if ( q.length() != 3 ){
            System.out.println("Error largo incorrecto");
        }
        if ( !q.toString().trim().equals("5 10 20") ){
            System.out.println("Representación del Queue incorrecta");
        }
        q.push(8);
        if ( q.length() != 4 ){
            System.out.println("Error largo incorrecto");
        }
        if ( !q.toString().trim().equals("5 10 20 8") ){
            System.out.println("Representación del Queue incorrecta");
        }
    }

    public static void pushPopTest(){
        Queue q = new Queue();
        q.push(5);
        q.push(10);
        q.push(20);
        q.push(8);
        if ( q.pop()!=5 ) {
            System.out.println("Salio elemento incorrecto");
        }
        if ( q.length() != 3 ){
            System.out.println("Error largo incorrecto");
        }
        if ( !q.toString().trim().equals("10 20 8") ){
            System.out.println("Representación del Queue incorrecta");
        }

        if ( q.pop()!=10 ) {
            System.out.println("Salio elemento incorrecto");
        }
        if ( q.length() != 2 ){
            System.out.println("Error largo incorrecto");
        }
        if ( !q.toString().trim().equals("20 8") ){
            System.out.println("Representación del Queue incorrecta");
        }
        q.push(3);
        if ( q.length() != 3 ){
            System.out.println("Error largo incorrecto");
        }
        if ( !q.toString().trim().equals("20 8 3") ){
            System.out.println("Representación del Queue incorrecta");
        }

        if ( q.pop()!=20 ) {
            System.out.println("Salio elemento incorrecto");
        }
        if ( q.length() != 2 ){
            System.out.println("Error largo incorrecto");
        }
        if ( !q.toString().trim().equals("8 3") ){
            System.out.println("Representación del Queue incorrecta");
        }

    }

    public static void testCapacidad(){
        Queue q = new Queue();

        for ( int i=0; i<10000; i++){
            if ( q.length() != i){
                System.out.println("Error en el tamanno de la cola");
            }

            q.push(i);

            if ( q.length() != i+1){
                System.out.println("Error en el tamanno de la cola");
            }
        }

        for ( int i=0; i<10000; i++){
            if ( q.length() != 10000-i){
                System.out.println("Error en el tamanno de la cola");
            }

            if ( q.pop() != i){
                System.out.println("Elemento no esperado");
            }

            if ( q.length() != 10000-i-1){
                System.out.println("Error en el tamanno de la cola");
            }
        }
    }

    public static void testConsistencia(){

        Queue q = new Queue();
        int nextPut = 0;
        int nextGet = 0;
        int tamanno = 0;

        for ( int i = 0; i<100000; i++){
            if ( q.length() != tamanno){
                System.out.println("Error en el tamanno de la cola");
            }

            if ( q.length()==0 || Math.random()>0.48 ){
                //poner
                q.push(nextPut++);
                tamanno++;
            } else {
                //sacar
                if ( q.pop() != nextGet++ ){
                    System.out.println("Elemento no esperado");
                }
                tamanno--;
            }

            if ( q.length() != tamanno){
                System.out.println("Error en el tamanno de la cola");
            }
        }
    }

    public static void main(String[] args){
        pushTest();
        pushPopTest();
        testCapacidad();
        testConsistencia();
    }

}