/**
 * Test clase N.
 * Este test prueba solo una *parte* de la tarea.
 * Su tarea ser probada con test adicionales no publicados, as que,
 * que su solucin funcione con este test no garantiza ninguna nota.
 * @author Luis Alberto Herrera
 */

import java.lang.Throwable.*;

public class TestTarea2 {

    /* Funcion que mata el programa si la condicion es falsa. */
    static private void probar(String msg, boolean condicion){
        if ( !condicion ){
            U.println(msg);
            System.exit(-1);
        }
   }

    private static void constructorTest(){
        N A = new N(10);
        N C = new N("0030");
        N D = new N("000000000000000000");
        N E = new N();

        probar ("constructorTest::Error 1",  A.toString().compareTo("10") == 0);
        probar ("constructorTest::Error 2",  C.toString().compareTo("30") == 0);
        probar ("constructorTest::Error 3",  D.toString().compareTo("0") == 0);
        probar ("constructorTest::Error 4",  E.toString().compareTo("0") == 0);
    }

    private static void compareTest(){
        N A = new N(10);
        N B = new N("10");
        N C = new N("30");
        N D = new N("00010");
        N E = new N(0);
        N F = new N();

        probar ("compareTest::Error 1", A.compareTo(B) == 0);
        probar ("compareTest::Error 2", A.compareTo(C) < 0);
        probar ("compareTest::Error 3", C.compareTo(A) > 0);
        probar ("compareTest::Error 4", A.compareTo(D) == 0);
        probar ("compareTest::Error 5", E.compareTo(F) == 0);
    }


    private static void sumaTest(){
        N A = new N(10);
        N B = new N("10");
        N C = new N("30");
        N D = new N("00010");
        N E = new N();
        
        N F = new N("99999999999999999999999999999"); //29 nueves
        N G = new N("100000000000000000000000000000"); //29 ceros



        probar ("sumaTest::Error 1", A.suma(B).compareTo(new N(20)) == 0);
        probar ("sumaTest::Error 2", A.suma(C).compareTo(new N("40")) == 0);
        probar ("sumaTest::Error 3", E.suma(D).compareTo(new N(10)) == 0);
        probar ("sumaTest::Error 4", F.suma( new N(1) ).compareTo(G) == 0);
    }


    public static void main(String[] args){
        constructorTest();
        compareTest();
        sumaTest();
    }
}
