function visualizacion_TLC(M,N,dist)

xini = -4;
xfin = 4;
nb = ceil(sqrt(M/10));
b = linspace(xini,xfin,nb+1)';
c = b+0.5*mean(diff(b));
c = c(1:end-1);

acum_normal = normcdf(b(2:end));
dens_normal = normpdf(c);

switch lower(dist)
    case 'unif'
        A = 10;
        B = 13;
        fun = @(x) A + (B-A)*rand(M,1);
        m = (A+B)/2;
        s = sqrt((A-B)^2/12);
        nombre = sprintf('uniforme(%3.1f,%3.1f)',A,B);
    case 'normal'
        mu = 10;
        sigma = 2;
        fun = @(x) mu + sigma*randn(M,1);
        m = mu;
        s = sqrt(sigma^2);
        nombre = sprintf('normal(%3.1f,%3.1f)',mu,sigma^2);
    case 'exp'
        lambda = 0.1;
        param = 1/lambda;
        fun = @(x) exprnd(param,M,1);
        m = param;
        s = sqrt(param^2);
        nombre = sprintf('exponencial(%3.1f)',lambda);
    case 'bernoulli'
        p = 0.5;
        fun = @(x) 0+(rand(M,1)<p);
        m = p;
        s = sqrt(p*(1-p));
        nombre = sprintf('Bernoulli(%3.1f)',p);
    case 'binomial'
        num = 50;
        p = 0.5;
        fun = @(x) binornd(num,p,M,1);
        m = p*num;
        s = sqrt(p*(1-p)*num);
        nombre = sprintf('binomial(%d,%3.1f)',num,p);
    case 'beta'
        A = 0.1;
        B = 0.1;
        fun = @(x) betarnd(A,B,M,1);
        m = A/(A+B);
        s = sqrt(A*B/( (A+B)^2 * (A+B+1)));
        nombre = sprintf('beta(%3.1f,%3.1f)',A,B);
    case 'lognormal'
        mu = 0;
        sigma = 1;
        fun = @(x) lognrnd(mu,sigma,M,1);
        m = exp(mu+sigma^2/2);
        s = sqrt(exp(2*mu+sigma^2)*(exp(sigma^2)-1));
        nombre = sprintf('lognormal(%3.1f,%3.1f)',mu,sigma^2);
end

P = zeros(M,1); % promedio

% Variables de la figura:
ancho=0.4; % en proporcion al ancho de la pantalla
alto=1.0; % en proporcion al alto de la pantalla
figure('Units','normalized','Position',[0.5-ancho/2 0.5-alto/2 ancho alto],'Color','w');

for n=1:N
    X = fun(0); % simulacion M variables
    P = (X + (n-1)*P)/n; % promedio
    Z = (P-m)/(s/sqrt(n)); % promedio normalizado
    
    H = histc(Z,b);
    H = H(1:end-1);
    F = cumsum(H)/M;
    H = (H/M)./diff(b);
    
    subplot(211);
    plot(b(2:end),acum_normal,'LineWidth',3,'Color','k');
    line(b(2:end),F,'LineWidth',2);
    axis([-4 4 0 1]);
    xlabel('Distribucion acumulada');
    title(sprintf('Distribucion de (n^{-1} \\Sigma_{i=1}^n X_i -\\mu)/(\\sigma/n^{1/2}), para n = %d',n));
    
    subplot(212);
    bar(c,H,1,'EdgeColor','none');
    line(c,dens_normal,'LineWidth',3,'Color','k');
    axis([-4,4,0,0.75]);
    xlabel('Densidad');
    
    pause(4/n^1.5);
    drawnow;
end

end