import lejos.nxt.*;
import lejos.navigation.Pilot;

/* esta clase representa un robot tipo auto */
public class AutoBot{
	/* 
	 * variables de instancia
	 * (variables que definen a un AutoBot)
 	 *
	 */	
	private double diamRueda; // diametro de las ruedas
	private double sepRueda; // distancia entre las ruedas delanteras 
	private Motor motorRuedaIzq; // motor asociado a la rueda delantera izquierda
	private Motor motRuedaDer; // motor asociado a la rueda delantera derecha
	private Pilot piloto; // el piloto sera el encargado de mover al robot
	private UltrasonicSensor us; // sensor de ultrasonido
	
	/* constructores */
	
	/* constrctor con parmetros */
	public AutoBot(double diamRueda, double sepRueda, Motor motRuedaDer, Motor motRuedaIzq, UltrasonicSensor us){
		this.diamRueda=diamRueda;
		this.sepRueda=sepRueda;
		this.motRuedaDer=motRuedaDer;
		this.motRuedaIzq=motRuedaIzq;
		this.us=us;
		this.piloto = new TachoPilot(diamRueda, sepRueda, motRuedaIzq, motRuedaDer);// como se tienen todos los datos para inicializar el piloto, no es necesario que se entregue como parametro		
	}
	
	/* constructor con valores por omisin */
	public AutoBot(){
		this.diamRueda=5;
		this.sepRueda=10;
		this.motRuedaIzq=Motor.A;
		this.motRuedaDer=Motor.B;
		this.us=us;
		this.piloto = new Pilot(diamRueda, sepRueda, motRuedaIzq, motRuedaDer);
	}
	
	/* mtodos */
	
	/* hace que el AutoBot avance 'distancia' centimetros, permitiendo retorno inmediato (inmediateReturn = true) o no */
	public void avanzar(int distancia, boolean inmediateReturn){
		this.piloto.travel(distancia, inmediateReturn);
	}

	/* hace que el AutoBot rote 'angulo' grados, permitiendo retorno inmediato o no */
	public void girar(int angulo, boolean inmediateReturn){
		this.piloto.rotate(angulo, inmediateReturn);
	}
	
	/* hace que el AutoBot avance 'distancia' centimetros, sin retorno inmediato */
	public void avanzar(int distancia){
		this.avanzar(distancia, false);
	}

	/* hace que el AutoBot rote 'angulo' grados, sin retorno inmediato */
	public void girar(int angulo){
		this.girar(angulo, false);
	}
	

	
	/* ¿Que es el retorno inmediato?
	 * 	Retorno inmediato es cuando no se espera terminar un metodo para seguir con la ejecucion del codigo
	 * 
	 * Ejemplo:
	 * 	Si en un trozo de codigo se escribe lo siguiente :
	 *  	"AutoBot ab = new AutoBot();
	 *  	ab.avanzar(20, true);
	 *  	ab.girar(90, true);"
	 *	el AutoBot 'ab' va a avanzar y luego inmediatamente se va a ejecutar lo que sigue en el coidgo, ab.girar(90), 
	 *	lo que resultaria en un movimiento hacia adelante y un giro en 90 simultaneamente.
     *	El AutoBot describiria una trayectoria curva.
	 *	
	 * 	Sin embargo, el siguiente codigo haria que el AutoBot describiera una trayectoria en forma de L
	 *  	"AutoBot ab = new AutoBot();
	 *  	ab.avanzar(20, true);
	 *  	ab.girar(90, true);
	 *		ab.avanzar(20, true);"
     *
	 */
	
}