import java.awt.*;

class GraficaFuncion extends Frame {

    public static void main(String[] args){
	new GraficaFuncion(args[0]).setVisible(true);
    }

    private static int W=300,H=300;
    private Funcion f;

    public GraficaFuncion(String s){
	setSize(W,H);
	
	if("cuadrado".equals(s)){
	    f = new Cuadrado();
	}else if("cubo".equals(s)){
	    f = new Cubo();
	}   
    }

    public void paint(Graphics g){
	graficar(f,20,-100,100,g,W,H);
    }

    public static void graficar(Funcion f, int n, double a, double b, Graphics g, int W, int H){
	double min = f.valor(a);
	double max = Integer.MIN_VALUE;
	double delta = (b-a)/n-1;

	// calcula min y max en la grilla de dibujo
	for(double x=a+delta; x<=b; x+=delta){
	    double y = f.valor(x);
	    min = Math.min(y,min);
	    max = Math.max(y,max);
	}
	
	// graficamos lineas en cada paso "delta"
	int h = 0;
	int v = H - pixel(f.valor(a), min, max, H);
	for(double x=a+delta; x<=b; x+=delta){
	    int h2 = pixel(x,a,b,W);
	    int v2 = H-pixel(f.valor(x),min,max,H);
	    g.drawLine(h,v,h2,v2);
	    h = h2; v = v2;
	}
    }

    private static int pixel(double x, double y, double z, int w){
	return (int) Math.round(w*(x-y)/(z-y));
    }	
}

interface Funcion {
    public double valor(double x);
}

class Cuadrado implements Funcion{
    public double valor(double x){
	return x*x;
    }
}

class Cubo implements Funcion{
    public double valor(double x){
	return x*x*x;
    }
}

class Sin implements Funcion{
    public double valor(double x){
	return Math.sin(x);
    }
}
