import java.awt.*;
import java.awt.event.*;

class Circulos extends Frame implements ActionListener{

    public static void main(String[] args){
	new Circulos().setVisible(true);
    }

    private Button circulo = new Button("Dibuja Circulo");
    private Button quit = new Button("Salir");

    private Canvas cv = new Canvas();
    private static final int W=300, H=300;

    public Circulos(){
	setSize(W,H+2*25);
	setLayout(new BorderLayout());

	add("North", circulo);
	add("South", quit);
	cv.setSize(W,H);
	add("Center", cv);

	circulo.addActionListener(this);
	quit.addActionListener(this);
    }

    public void actionPerformed(ActionEvent e){
	if(e.getSource() == quit)
	    System.exit(0);

	int h = azar(0,W-1);
	int v = azar(0,H-1);
	int d = azar(0,Math.min(W,H)-1);
	int r = d/2;
	
	Graphics g = cv.getGraphics();

	// color RGB
	int cr = azar(0,255);
	int cg = azar(0,255);
	int cb = azar(0,255);
	g.setColor(new Color(cr,cg,cb));

	g.drawOval(h-r,v-r,d,d);
    }

    public static int azar(int x, int y){
	int r = x + (int)(Math.random()*(y-x+1));
	System.out.println(r);
	return r;
    }

}
