function x=integrarParcial(f1,K,x0,xn,n)
%f1 recibe el nombre de la funcin a integrar como un String
%K es la variable que no se integra
%x0 es el lmite inferior de integracin
%xn es el lmite superior de integracin
%n es el nmero de puntos en los que se divide el intervalo [x0,xn]
 
%a almacena el valor de la suma de los trminos de la frmula de la integral compuesta %de Simpson

f=fcnchk(f1); %Se reconoce f como la funcin cuyo nombre fue recibido en f1
a=f(x0,K);   %Se asigna a a el primer valor de la suma
k=4;          %Se asigna a k el valor inicial 4
h=(xn-x0)/n;  %Se define h como la longitud de cada subintervalo
for i=1:(n-1) %Se suman los trminos desde X1 hasta X(n-1)
    if rem(i,2)==0 %Si i es par, k=2; de lo contrario, k vale 4
        k=2;
    end               %Se suma a a el valor de k*f(xi,T0),donde k es 2
    a=a+k*f(x0+i*h,K); %si "i" es par y 4 si "i" es impar
    k=4;           %Se vuelve a dar a "k" el valor 4 que tena inicialmente
end
a=a+f(xn,K);          %Se suma el ltimo trmino f(xn,TO)
x=a*h/3;       %Se define el resultado final como el valor de esta suma por
               %la longitud de cada subintervalo dividida por 3
end
