import java.awt.*; import java.awt.event.*;
class Reloj extends Frame implements ActionListener
{
private final int W=300,H=300; 		//ancho y alto de tela
private Canvas cv = new Canvas();	//"tela" para dibujar
private TextField hora = new TextField();
private Button quit = new Button("quit");

static public void main(String[]args){
	Reloj r = new Reloj();
	r.pack();
	r.setVisible(true);
}

public Reloj(){					//constructor
   setSize(W,H+50);				//tamao de la ventana
   cv.setSize(W,H);				//tamao de la tela
   Panel p=new Panel(); p.setLayout(new GridLayout(1,2));
   p.add(new Label("HHMM:")); p.add(hora);
   setLayout(new BorderLayout());
   add("North",p); add("Center",cv);add("South",quit);
   hora.addActionListener(this);
   quit.addActionListener(this);
}
public void actionPerformed(ActionEvent x){
  if(x.getSource()==quit) System.exit(0);
  String s = hora.getText();
  int index = s.indexOf(":"); 
  dibujarReloj(Integer.parseInt(s.substring(0,index)),
               Integer.parseInt(s.substring(index+1)));
}
public void dibujarReloj(int x,int y){  
  Graphics g = cv.getGraphics();
  //dibujar crculo
  int r = W/2; //radio
  g.clearRect(0,0,2*r,2*r); 	//limpia la hora anterior
  g.drawOval(0,0,2*r,2*r); 		//dibuja la hora actual
  //dibujar minutero
  double angulo = (15-y)*(2*Math.PI/60);
  g.drawLine(r, r,
             r + (int)(r*Math.cos(angulo)), 
             r - (int)(r*Math.sin(angulo)));
  //dibujar horario
  angulo = (3-(x%12 + y/60.0))*(2*Math.PI/12);
  g.drawLine(r, r, 
             r + (int)(r/2*Math.cos(angulo)),
             r - (int)(r/2*Math.sin(angulo)));
}
}

