import java.io.*;
class politico{
	String rut;
	String nombres;
	String apellidos;
	String partidoPolitico;
	boolean esCoimero = false;
	int fechaNacimiento;
	
	public politico(String nomb, String apell, String rut, int fechaNac){
		nombres = nomb;
		apellidos = apell;
		this.rut = rut;
		fechaNacimiento = fechaNac;
	}
	
	public politico(String nombreArchivo)throws IOException{
		BufferedReader b = new BufferedReader(new FileReader(nombreArchivo));
		rut = b.readLine();
		nombres = b.readLine();
		apellidos = b.readLine();
		partidoPolitico = b.readLine();
		if(b.readLine().equals("true"))
			esCoimero = true;
		fechaNacimiento = Integer.parseInt(b.readLine());
		b.close();
	}
	
	public void setMoral(boolean esCoimero){
		this.esCoimero = esCoimero;
	}
	
	public void setPartido(String partido){
		partidoPolitico = partido;
	}
	
	public String getFecha(){
		return (fechaNacimiento/1000000+"/"+(fechaNacimiento%1000000)/10000+"/"+(fechaNacimiento%10000));
	}
	
	public void escribir(String nombreArchivo)throws IOException{
		PrintWriter f = new PrintWriter(new FileWriter(nombreArchivo));
		f.println(rut);
		f.println(nombres);
		f.println(apellidos);
		f.println(partidoPolitico);
		f.println(esCoimero);
		f.println(fechaNacimiento);
		f.close();
	}
}		