import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;

class Consulta extends Frame implements ActionListener {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * 
	 */
	

	// método main
	static public void main(String[] args) {
		new Consulta().show();
	}

	// componentes
	private TextField cuenta = new TextField();
	private Label saldo = new Label();
	private Button quit = new Button("quit");

	// constructor
	public Consulta() {
		// diagramar paneles
		Panel p1 = new Panel();
		p1.setLayout(new GridLayout(1, 2));
		p1.add(new Label("cuenta?"));
		p1.add(cuenta);
		Panel p2 = new Panel();
		p2.setLayout(new GridLayout(1, 2));
		p2.add(new Label("saldo="));
		p2.add(saldo);
		// diagramar ventana
		setLayout(new GridLayout(4, 1));
		setSize(200, 4 * 50);
		add(new Label("Consultar saldo"));
		add(p1);
		add(p2);
		add(quit);
		// activar escuchadores
		cuenta.addActionListener(this);
		quit.addActionListener(this);
	}

	public void actionPerformed(ActionEvent x) {
		if (x.getSource() == quit)
			System.exit(0);
		BufferedReader a;
		try {
			a = new BufferedReader(new FileReader("banco.txt"));

			String linea;
			while ((linea = a.readLine()) != null) {
				
				CuentaAux c = new CuentaAux(linea);
				
				if (cuenta.getText().equals(c.numero)) {
					saldo.setText("" + c.saldo);
					break;
				}
			}
			if (linea == null)
				saldo.setText("no existe");
			a.close();

		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

	}
}