import java.io.*;

abstract class Figura
{
	double x, y;
	String N;
	
	public Figura(double a, double b, String n){ x=a; y=b; N=n; }
	
	public Figura(String n){ N=n; x=0; y=0; }
	
	public Figura(double a, double b){ x=a; y=b; N="FIGURA"; }
	
	public Figura(){x=0; y=0; N="FIGURA";}
}


interface Caracteristicas
{
	public double perimetro();
	
	public double area();
}



class Circulo extends Figura implements Caracteristicas
{
	double r;//radio
	
	public Circulo( double X, double Y,double R)
	{ super(X,Y,"CIRCULO"); r=R; }// un tipo de constructor, peuden ser muchos
	
	public double perimetro()
	{ return 2*Math.PI*r; }// <=> 2*Math.PI*this.r
	
	public double area()
	{ return Math.PI*r*r; } // <=> Math.PI*this.r*this.r
	
	public int compareTo(Circulo X)
	{
		//dejamos las areas como un intero, pero primero agregamos los 3 decimales
		//(solo para escribir menos)
		int a1=(int)(this.area()*1000),
		    a2=(int)(X.area()*1000);
		
		if(a1>a2) return 1;
		else if(a2>a1) return -1;
		else return 0;
	}
}


class Rectangulo extends Figura implements Caracteristicas
{
	double an, al;//ancho y alto 
	
	public Rectangulo(double X, double Y, double AN, double AL)// un tipo de constructor, peuden ser muchos
	{ super(X,Y,"RECTANGULO"); an=AN; al=AL; }
	
	public Rectangulo(double AN, double AL)// un tipo de constructor, peuden ser muchos
	{ super("RECTANGULO"); an=AN; al=AL; }
	
	public double perimetro()
	{ return 2*(an+al); } // <=> 2*(this.an + this.al)
	
	public double area()
	{ return an*al; } // <=> this.an*this.al
	
	public boolean esCuadrado()
	{ return an==al; } // <=> this.an==this.al
	
	public int compareTo(Rectangulo X)
	{
		//dejamos las areas como un intero, pero primero agregamos los 3 decimales
		//(solo para escribir menos)
		int a1=(int)(this.area()*1000),
		    a2=(int)(X.area()*1000);
		
		if(a1>a2) return 1;
		else if(a2>a1) return -1;
		else return 0;
	}
}


class Triangulo extends Figura implements Caracteristicas
{
	double x2,y2,x3,y3;
	
	public Triangulo(double X1, double Y1, double X2, double Y2, double X3, double Y3)// un tipo de constructor, peuden ser muchos
	{
		super(X1,Y1,"TRIANGULO"); x2=X2; y2=Y2; x3=X3; y3=Y3;
		
		double m1=(Y2-Y1)/(X2-X1), m2=(Y3-Y2)/(X3-X2), m3=(Y1-Y3)/(X1-X3);
		
		if(m1==m2 && m2==m3) U.abortar("Los puntos entregados no forman un Ttriangulo");	
	}
	
	protected double distancia(double X1, double Y1, double X2, double Y2)
	{ return Math.sqrt(Math.pow(X1-X2,2)+Math.pow(Y1-Y2,2)); }
	
	public double perimetro()
	{ return distancia(x,y,x2,y2)+distancia(x2,y2,x3,y3)+distancia(x3,y3,x,y); }
	
	public double area()//usando la formula de Hern
	{
		double sp=((this.perimetro())/2), 
		       a=distancia(x,y,x2,y2),
		       b=distancia(x2,y2,x3,y3),
		       c=distancia(x3,y3,x,y);
		return Math.sqrt(sp*(sp-a)*(sp-b)*(sp-c));
	}
	
	public String tipo()
	{
		//cada lado solo con 3 decimales (truncados)
		double a=((double)((int)(distancia(x,y,x2,y2)*1000)))/1000.0,
		       b=((double)((int)(distancia(x2,y2,x3,y3)*1000)))/1000.0,
		       c=((double)((int)(distancia(x3,y3,x,y)*1000)))/1000.0;
		
		if(a==b && b==c) return "Equilatero";
		else if(a==b || a==c || b==c) return "Isosceles";
		else return "Escaleno";
	}
	
	public int compareTo(Triangulo X)
	{
		//dejamos las areas como un intero, pero primero agregamos los 3 decimales
		//(solo para escribir menos)
		int a1=(int)(this.area()*1000),
		    a2=(int)(X.area()*1000);
		
		if(a1>a2) return 1;
		else if(a2>a1) return -1;
		else return 0;
	}
}




class Programa
{
	static public void main(String[]args) throws IOException
	{
		U.println("---- Clase Auxiliar Extra ----");
		U.println(" ");
		while(true)
		{
			int o=U.readInt("Que figura quiere ingresar? (1=Circulo, 2=Rectangulo, 3=Triangulo, 4=Salir)? ");
			U.println("");
			
			if(o==4) break;
			if(o==1)
			{
				U.println("Crearemos un Circulo:");
				double x = U.readDouble("Ingrese la coordenada x del centro: ");
				double y = U.readDouble("Ingrese la coordenada y del centro: ");
				double r = U.readDouble("Ingrese el radio: ");
				Circulo C=new Circulo(x,y,r);
				U.println("Perimetro= "+C.perimetro()+"   Area= "+C.area());
			}
			if(o==2)
			{
				U.println("Crearemos un Rectangulo:");
				double an = U.readDouble("Ingrese el ancho: ");
				double al = U.readDouble("Ingrese el alto: ");
				Rectangulo R=new Rectangulo(an,al);
				U.println("Perimetro= "+R.perimetro()+"   Area= "+R.area());
				if(R.esCuadrado()) U.println("La figura Ingresada ES un Cuadrado");
				else U.println("La figura Ingresada NO es un Cuadrado");
			}
			if(o==3)
			{
				U.println("Crearemos un Triangulo:");
				double x1 = U.readDouble("Ingrese la coordenada x del 1er vertice: ");
				double y1 = U.readDouble("Ingrese la coordenada y del 1er vertice: ");
				double x2 = U.readDouble("Ingrese la coordenada x del 2do vertice: ");
				double y2 = U.readDouble("Ingrese la coordenada y del 2do vertice: ");
				double x3 = U.readDouble("Ingrese la coordenada x del 3er vertice: ");
				double y3 = U.readDouble("Ingrese la coordenada y del 3er vertice: ");
				Triangulo T=new Triangulo(x1,y1,x2,y2,x3,y3);
				U.println("Perimetro= "+T.perimetro()+"   Area= "+T.area());
				String t=T.tipo();
				U.println("Es un Triangulo "+t);
			}
			
			U.println(" ");
		}
		
		U.println("");
		U.println("------ FIN DEL PROGRAMA ------");
		U.println("");
		
	}
}