/*
 * WebSPHINX web crawling toolkit
 * Copyright (C) 1998,1999 Carnegie Mellon University 
 * 
 * This library is free software; you can redistribute it
 * and/or modify it under the terms of the GNU Library
 * General Public License as published by the Free Software 
 * Foundation, version 2.
 *
 * WebSPHINX homepage: http://www.cs.cmu.edu/~rcm/websphinx/
 */
package websphinx;

import java.util.Vector;
import java.util.Enumeration;

/**
 * Base class for pattern matchers.
 */
public abstract class Pattern 
//#ifdef JDK1.1 
implements java.io.Serializable 
//#endif JDK1.1
{

    public abstract PatternMatcher match (Region region);

    public boolean found (Region region) {
        return match(region).hasMoreElements ();
    }

    public Region oneMatch (Region region) {
        return match(region).nextMatch ();
    }

    public Region[] allMatches (Region region) {
        Vector v = new Vector ();
        PatternMatcher enum = match (region);
        Region r;
        while ((r = enum.nextMatch ()) != null)
            v.addElement (r);
        
        Region[] regions = new Region[v.size ()];
        v.copyInto (regions);
        return regions;
    }

    public boolean found (String string) {
        return found (new Page (string));
    }

    public Region oneMatch (String string) {
        return oneMatch (new Page (string));
    }

    public Region[] allMatches (String string) {
        return allMatches (new Page (string));
    }
    
    public String[] getFieldNames () {
        return new String[0];
    }
    
    /**
     * Return a string representation of the pattern.
     */
    public abstract String toString ();

    public static final String groups = "Pattern.groups";

}

