/*
 * WebSPHINX web crawling toolkit
 * Copyright (C) 1998,1999 Carnegie Mellon University 
 * 
 * This library is free software; you can redistribute it
 * and/or modify it under the terms of the GNU Library
 * General Public License as published by the Free Software 
 * Foundation, version 2.
 *
 * WebSPHINX homepage: http://www.cs.cmu.edu/~rcm/websphinx/
 */
package websphinx;

/**
 * Crawl event listener.
 */
public interface CrawlListener {
    /**
     * Notify that the crawler started.
     */
    public abstract void started (CrawlEvent event);

    /**
     * Notify that the crawler ran out of links to crawl
     */
    public abstract void stopped (CrawlEvent event);

    /**
     * Notify that the crawler's state was cleared.
     */
    public abstract void cleared (CrawlEvent event);

    /**
     * Notify that the crawler timed out.
     */
    public abstract void timedOut (CrawlEvent event);

    /**
     * Notify that the crawler was paused.
     */
    public abstract void paused (CrawlEvent event);

}
