/*
 * WebSPHINX web crawling toolkit
 * Copyright (C) 1998,1999 Carnegie Mellon University 
 * 
 * This library is free software; you can redistribute it
 * and/or modify it under the terms of the GNU Library
 * General Public License as published by the Free Software 
 * Foundation, version 2.
 *
 * WebSPHINX homepage: http://www.cs.cmu.edu/~rcm/websphinx/
 */
package websphinx;

/**
 * Crawling event.  CrawlEvents are broadcast when the
 * crawler starts, stops, or clears its state.
 */
public class CrawlEvent
{
    private Crawler crawler;
    private int id;

    /**
     * Crawler started.
     */
    public static final int STARTED = 0;
    
    /**
     * Crawler ran out of links to crawl
     */
    public static final int STOPPED = 1;

    /**
     * Crawler's state was cleared.
     */
    public static final int CLEARED = 2;

    /**
     * Crawler timeout expired.
     */
    public static final int TIMED_OUT = 3;

    /**
     * Crawler was paused.
     */
    public static final int PAUSED = 4;

    /**
     * Make a CrawlEvent.
     * @param crawler Crawler that generated this event
     * @param id event id (one of STARTED, STOPPED, etc.)
     */
    public CrawlEvent (Crawler crawler, int id) {
        this.crawler = crawler;
        this.id = id;
    }

    /**
     * Get crawler that generated the event
     * @return crawler
     */
    public Crawler getCrawler () { 
        return crawler;
    }

    /**
     * Get event id.
     * @return one of STARTED, STOPPED, CLEARED, TIMED_OUT,
     * or PAUSED.
     */
    public int getID () { return id; }

}
