package symantec.itools.awt;


import java.awt.BorderLayout;
import java.awt.Color;
//import java.awt.SystemColor; JDK1.1
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FontMetrics;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Scrollbar;
import java.awt.Panel;
import java.awt.Rectangle;
//import java.awt.ItemSelectable; JDK1.1
//import java.awt.AWTEventMulticaster; JDK1.1
//import java.awt.event.ItemEvent;
//import java.awt.event.ItemListener;
//import java.awt.event.KeyEvent;
//import java.awt.event.KeyAdapter;
//import java.awt.event.MouseEvent;
//import java.awt.event.MouseAdapter;
//import java.awt.event.FocusEvent;
//import java.awt.event.FocusAdapter;
//import java.awt.event.AdjustmentEvent;
//import java.awt.event.AdjustmentListener;
//import java.awt.event.ActionEvent;
//import java.awt.event.ActionListener;
import java.util.Vector;
//import java.beans.PropertyVetoException;
//import java.beans.PropertyChangeListener;
//import java.beans.VetoableChangeListener;
//import java.beans.PropertyChangeEvent;

//	01/15/97	RKM	Changed drawTree to make certain g1 has a font, before calling getFontMetrics on it
//	01/15/07	RKM	Added invalidate to setTreeStructure
//	01/29/97	TWB	Integrated changes from Windows and RKM's changes
// 	01/29/97	TWB	Integrated changes from Macintosh
//  02/05/97    MSH Changed so that draws from first visible node
//  02/27/97    MSH Merged change to add SEL_CHANGED
//  04/02/97    TNM Draw all vertical lines
//  04/14/97    RKM Changed bogus invalidates to repaint
//				RKM	Changed hard coded sbVWidth to use preferredSize.width
//				RKM Changed getTreeStructure so it actually returned a representation of what was in the treeview
//				RKM	Rearranged a lot of stuff to get this to work
//				RKM Changed g1.drawRect in drawTree to not overlap the scrollbar
//				RKM Changed parseTreeStructure to not force a root node
//  05/02/97    RKM Add arg to addSibling so caller could control whether the sible was added as the last sibling or not
//				RKM	Changed insert to call addSibling with false when handling NEXT
//				RKM	Kept addSibling with two params for compatibility
//	05/31/97	RKM	Updated to support Java 1.1
//					Made properties bound & constrained
//					Removed get/setBackground & get/setForeground overrides, getter did nothing but call the super
//					and setters were calling repaint, no one else does this
//					Deprecated foreground and background hilite colors, used system colors instead
//					Deprecated SEL_CHANGED, replaced by ItemSelectable interface
//					Hid scrollbar on creation, to avoid ugly redraw problems
//					Changed to triggered redraw
//					NOTE: SystemColor seems to be broken on Mac
// 06/01/97		RKM	Changed symantec.beans references to java.beans
// 05/13/97     TNM Added horizontal scrollbar
// 05/15/97     TNM Check for vendor to corect scrollbar problem
// 06/09/97     CAR Modified check for vendor to include java.version 1.1.x
// 06/19/97     TNM Merging changes

/**
 * Creates an "outline view" of text headings and, optionally, images.
 * The headings are arranged in a hierarchical fashion, and can be
 * expanded to show their sub-headings or collapsed, hiding their
 * sub-headings.
 * <p>
 * A TreeView is typically used to display information that is organized in a
 * hierarchical fashion like an index or table of contents.
 * <p>
 * A TreeNode2 object is used for each heading.
 * @see TreeNode2
 */
public class TreeView2
	extends Panel
                //	implements ItemSelectable JDK1.1
{
	// constants for insertion
	/**
	 * Constant indicating that the new node is to be a child
	 * of the existing node.
	 * @see #insert
	 */
	public static final int CHILD   = 0;
	/**
	 * Constant indicating that the new node is to be the next
	 * sibling of the existing node.
	 * @see #insert
	 */
	public static final int NEXT    = CHILD + 1;
	/**
	 * Constant indicating that the new node is to be the last
	 * sibling of the existing node.
	 * @see #insert
	 */
	public static final int LAST    = CHILD + 2;

    /**
     * @deprecated As of JDK version 1.1,
     * replaced by ItemSelectable interface.
     * @see java.awt.ItemSelectable
     */
	public static final int SEL_CHANGED = 1006; //selection changed event

	private TreeNode2 rootNode;         		 // root node of tree
	private TreeNode2 selectedNode;				// highlighted node
	private TreeNode2 topVisibleNode;			// first node in window

	protected Scrollbar	verticalScrollBar;	// vertical scrollbar
	int			sbVPosition = 0;		// hold value of vertical scrollbar
	int			sbVWidth;       		// width of vertical scrollbar
	long		sbVTimer = -1;			// time of last vert scrollbar event
	private boolean sbVShow = false;    // show or hide vertical scrollbar
	protected int count = 0;    		// Number of nodes in the tree
	protected int	viewCount = 0;		// Number of viewable nodes in the tree
	                        			// (A node is viewable if all of its
	                        			// parents are expanded.)
    protected Scrollbar horizontalScrollBar; // horizontal scrollbar
	int			sbHPosition=0;	// hold value of horizontal scrollbar
	int			sbHHeight = 0;  // height of horizontal scrollbar
    private int sbHSize;        // size of horizontal scrollbar
    private int newWidth = 0;   // for horizontal scrollbar
   	private boolean sbHShow = false; // show or hide horizontal scrollbar
	private int sbHLineIncrement = 4;

	private int viewHeight = 300;
	private int viewWidth  = 300; // pixel size of tree display
	private int viewWidest = 0 ;  // widest item displayable (for horz scroll)

	int cellSize    = 16;   // size of node image
	int clickSize   = 8;    // size of mouse toggle (plus or minus)
	int imageInset  = 3;    // left margin of node image
	int textInset   = 6;    // left margin for text
	int textBaseLine= 3;    // position of font baseline from bottom of cell
	private FontMetrics fm; // current font metrics
    //long timeMouseDown;     // save time of last mouse down (for double click)
    //int doubleClickResolution = 333; // double-click speed in milliseconds
    protected boolean isSun1_1; // checks for scrollbars that have different max value

	/**
	 * Offscreen Image used for buffering the painting process.
	 */
	protected Image im1;    // offscreen image
	/**
	 * Offscreen graphics context used for buffering the painting process.
	 */
	protected Graphics g1 = null;  // offscreen graphics context


	//
	// Constructors
	//

	/**
	 * Constructs an empty TreeView2.
	 */
	public TreeView2()
	{
		super.setLayout(null);
	    verticalScrollBar = new Scrollbar(Scrollbar.VERTICAL);
        verticalScrollBar.hide();
        add(verticalScrollBar);
        horizontalScrollBar = new Scrollbar(Scrollbar.HORIZONTAL);
        horizontalScrollBar.hide();
        add(horizontalScrollBar);
        // Sun has different max value for setValues method in ScrollBar
        //isSun1_1 = ( System.getProperty("java.vendor").startsWith("Sun Microsystems Inc.")
        //             && (System.getProperty("java.version").startsWith("11")
        //                 || System.getProperty("java.version").indexOf("1.1") > -1) );
        isSun1_1 = true;
	}

	/**
	 * Constructs a TreeView2 with the given node.
	 *
	 * @param head the root node of the constructed tree
	 */
	public TreeView2(TreeNode2 head)
	{
	    this();
	    selectedNode = rootNode = head;
	    count = 1;
	}

	//
	// Properties
	//

	public synchronized void clear ()
	{
	    rootNode = selectedNode = null;
	    count = 0;
	    viewCount = 0;
	    triggerRedraw ();
	}

    /**
     * Initializes the TreeView2 from a string array.
     * There is one string for each node in the array. That string
     * contains the text of the node indented with same number of
     * leading spaces as the depth of that node in the tree.
     * @param s the string array used for initialization
     * @see #getTreeStructure
     */
	public void setTreeStructure(String s[])
	{
	    rootNode = selectedNode = null;

	    try
	    {
	        parseTreeStructure(s);
	    }
	    catch(InvalidTreeNode2Exception e)
	    {
	        System.out.println(e);
	    }

		triggerRedraw();

		//!!!RKM!!! If preferredSize ever has to do with actual data (duh), uncomment this
	    //invalidate();
	}

    /**
     * Gets a string array that reflects the current TreeView2's contents.
     * There is one string for each node in the array. That string
     * contains the text of the node indented with same number of
     * leading spaces as the depth of that node in the tree.
     * @return the string array that reflects the TreeView2's contents
     * @see #setTreeStructure
     */
	public String[] getTreeStructure()
	{
		//Create a vector representing current tree structure
		if (rootNode==null) return null;
		Vector nodesVector = new Vector(count);
		rootNode.depth = 0;
		vectorize(rootNode,false,nodesVector);

		//Convert this to a String[]
		int numNodes = nodesVector.size();
		String[] treeStructure = new String[numNodes];
		for (int i = 0;i < numNodes;i++)
		{
			TreeNode2 thisNode = (TreeNode2)nodesVector.elementAt(i);

			//Add appropriate number of blanks
			String treeString = "";
			for (int numBlanks = 0;numBlanks < thisNode.depth;numBlanks++)
				treeString += ' ';

			//Add tree
			treeString += thisNode.text;

			//Put string into array
			treeStructure[i] = treeString;
		}

	    return treeStructure;
	}

	//
	// Deprecated Properties
	//

	/**
     * @deprecated As of JDK version 1.1,
     * replaced by use of SystemColors.textHighlightText.
	 */
	public void setFgHilite(Color c)
	{
	}

	/**
     * @deprecated As of JDK version 1.1,
     * replaced by use of SystemColors.textHighlightText.
	 */
	public Color getFgHilite()
	{
	    //return SystemColor.textHighlightText;
            return Color.black;
	}

	/**
     * @deprecated As of JDK version 1.1,
     * replaced by use of SystemColors.textHighlight.
	 */
	public void setBgHilite(Color c)
	{
	}

	/**
     * @deprecated As of JDK version 1.1,
     * replaced by use of SystemColors.textHighlight.
	 */
	public Color getBgHilite()
	{
	    //return SystemColor.textHighlight;
            return Color.white;
	}

	//
	// ItemSelectable interface
	//

    /**
     * Returns the selected items or null if no items are selected.
     * <p>
     * This is a standard method of the ItemSelectable interface.
     */
    public Object[] getSelectedObjects()
    {
    	if (selectedNode == null)
    		return null;

    	TreeNode2[] selectedObjects = new TreeNode2[1];
    	selectedObjects[0] = selectedNode;

    	return selectedObjects;
    }

    /**
     * Add a listener to recieve item events when the state of
     * an item changes.
     * <p>
     * This is a standard method of the ItemSelectable interface.
     * @param l the listener to recieve events
     * @see ItemEvent
     */
    /* JDK1.1
    public void addItemListener(ItemListener l)
    {
        itemListener = AWTEventMulticaster.add(itemListener, l);
    }
    */

    /**
     * Removes an item listener.
     * <p>
     * This is a standard method of the ItemSelectable interface.
     * @param l the listener being removed
     * @see ItemEvent
     */
    /* JDK1.1
    public void removeItemListener(ItemListener l)
    {
        itemListener = AWTEventMulticaster.remove(itemListener, l);
    }
    */

	//
	// Methods
	//

	// Insert a new node relative to a node in the tree.
	// position = CHILD inserts the new node as a child of the node
	// position = NEXT inserts the new node as the next sibling
	// position = LAST inserts the new node as the last sibling
	/**
	 * Inserts a new node relative to an existing node in the tree.
	 * @param newNode the new node to insert into the tree
	 * @param relativeNode the existing node used for a position reference
	 * @param position where to insert the new node relative to relativeNode.
	 * Legal values are CHILD, NEXT and LAST.
	 * @see #CHILD
	 * @see #NEXT
	 * @see #LAST
	 * @see #append
	*/
	public void insert(TreeNode2 newNode, TreeNode2 relativeNode, int position)
	{
	    if (newNode == null || relativeNode == null)
	        return;

	    if (exists(relativeNode)==false)
	        return;

	    switch (position)
	    {
	        case CHILD:
	            addChild(newNode, relativeNode);
	            break;

	        case NEXT:
	            addSibling(newNode, relativeNode, false);
	            break;

	        case LAST:
	            addSibling(newNode, relativeNode, true);
	            break;

	        default:
	            // invalid position
	            return;
	    }
	}

    /**
     * Returns the "root" node.
     * The root node is the first top-level node in the tree hierarchy.
     * All other nodes are either children or siblings of that one.
     * @return the root tree node
     */
	public TreeNode2 getRootNode()
	{
	    return rootNode;
	}

	/**
	 * Returns the total number of nodes in the tree.
	 */
	public int getCount()
	{
	    return count;
	}

	/**
	 * Returns the total number of viewable nodes in the tree.
     * A node is viewable if all of its parents are expanded.
     */
	public int getViewCount()
	{
	    return viewCount;
	}

	/**
	 * Determines if the given node is viewable.
     * A node is viewable if all of its parents are expanded.
     * @param node the node to check
     * @return true if the node is visible, false if it is not
     * @see #viewable(java.lang.String)
	 */
	boolean viewable(TreeNode2 node)
	{
	    for (int i=0; i<viewCount; i++)
	    {
	        if (node == v.elementAt(i))
	        {
	            return true;
	        }
	    }

	    return false;
	}

	/**
	 * Determines if the node with the given text is viewable.
     * A node is viewable if all of its parents are expanded.
     * @param s the node text to find
     * @return true if the node is visible, false if it is not
     * @see #viewable(TreeNode2)
	 */
	boolean viewable(String s)
	{
	    if (s==null)
	    {
	        return false;
	    }

	    for (int i=0; i<viewCount; i++)
	    {
	        TreeNode2 tn = (TreeNode2)v.elementAt(i);

	        if (tn.text != null)
	        {
	            if (s.equals(tn.text))
	            {
	                return true;
	            }
	        }
	    }

	    return false;
	}

	/**
	 * Determines if the given node is in the TreeView2.
     * @param node the node to check
     * @return true if the node is in the TreeView2, false if it is not
     * @see #exists(java.lang.String)
	 */
	public boolean exists(TreeNode2 node)
	{
	    recount();

	    for (int i=0; i<count; i++)
	    {
	        if (node == e.elementAt(i))
	        {
	            return true;
	        }
	    }

	    return false;
	}

	/**
	 * Determines if the node with the given text is in the TreeView2.
	 * @param s the node text to find
     * @return true if the node is in the TreeView2, false if it is not
     * @see #exists(TreeNode2)
	 */
	public boolean exists(String s)
	{
	    recount();

	    if (s==null)
	    {
	        return false;
	    }

	    for (int i=0; i<count; i++)
	    {
	        TreeNode2 tn = (TreeNode2)e.elementAt(i);

	        if (tn.text != null)
	        {
	            if (s.equals(tn.text))
	            {
	                return true;
	            }
	        }
	    }

	    return false;
	}

	// add new node to level 0
	/**
	 * Adds a new node at root level. If there is no root node, the given
	 * node is made the root node. If there is a root node, the given node
	 * is made a sibling of the root node.
	 * @param newNode the new node to add
	 * @see #insert
	 */
	public void append(TreeNode2 newNode)
	{
	    if (rootNode == null)
	    {
	        rootNode = newNode;
	        selectedNode = rootNode;
	        count = 1;
	        triggerRedraw ();
	    }
	    else
	    {
	        addSibling(newNode, rootNode, true);
	    }
	}

	void addChild(TreeNode2 newNode, TreeNode2 relativeNode)
	{
	    if (relativeNode.child == null)
	    {
	        relativeNode.child = newNode;
	        newNode.parent = relativeNode;
	        count++;
	        triggerRedraw ();
	    }
	    else
	    {
	        addSibling(newNode, relativeNode.child, true);
	    }

	    relativeNode.numberOfChildren++;
	}

	void addSibling(TreeNode2 newNode, TreeNode2 siblingNode)
	{
		addSibling(newNode,siblingNode,true);
	}

	void addSibling(TreeNode2 newNode, TreeNode2 siblingNode, boolean asLastSibling)
	{
		if (asLastSibling)
		{
			//Find last sibling
			TreeNode2 tempNode = siblingNode;
			while (tempNode.sibling != null)
				tempNode = tempNode.sibling;

			tempNode.sibling = newNode;
		}
		else
		{
			//Insert the newNode below the siblingNode
			newNode.sibling = siblingNode.sibling;

			siblingNode.sibling = newNode;
		}

		//Set the parent of the new node to the parent of the sibling
		newNode.parent = siblingNode.parent;

		count++;
		triggerRedraw ();
	}

	/**
	 * Removes the node with the given text from the TreeView2.
	 * @param s the node text to find
     * @return the TreeNode2 removed from this TreeView2 or null if not found
     * @see #remove(TreeNode2)
     * @see #removeSelected
	 */
	public TreeNode2 remove(String s)
	{
		recount();

		for (int i=0; i<count; i++)
		{
			TreeNode2 tn = (TreeNode2)e.elementAt(i);

			if (tn.text != null)
			{
			    if (s.equals(tn.text))
			    {
			        remove(tn);
			        triggerRedraw ();
			        return tn;
			    }
			}
		}

		return null;
	}

	/**
	 * Removes the currently selected node from the TreeView2.
     * @see #remove(TreeNode2)
     * @see #remove(java.lang.String)
	 */
	public void removeSelected()
	{
	    if (selectedNode != null)
	    {
	        remove(selectedNode);
	    }
	}

	/**
	 * Removes the given node from the TreeView2.
	 * @param node the node to remove
     * @return the TreeNode2 removed from this TreeView2 or null if not found
     * @see #remove(java.lang.String)
     * @see #removeSelected
	 */
	public void remove(TreeNode2 node)
	{
	    if (!exists(node))
	    {
	        return;
	    }

	    if (node == selectedNode)
	    {
	        int index = v.indexOf(selectedNode);

	        if (index == -1)
	        {    //not viewable
	            index = e.indexOf(selectedNode);
	        }

	        if (index > viewCount-1)
	        {
	            index = viewCount-1;
	        }

	        if (index>0)
	        {
	            changeSelection((TreeNode2)v.elementAt(index-1));
	        }
	        else if (viewCount>1)
	        {
	            changeSelection((TreeNode2)v.elementAt(1));
	        }
	    }

	    // remove node and its decendents
	    if (node.parent != null)
	    {
	        if (node.parent.child == node)
	        {
	            if (node.sibling != null)
	            {
	                node.parent.child = node.sibling;
	            }
	            else
	            {
	                node.parent.child = null;
	                node.parent.collapse();
	            }
	        }
	        else
	        {
	            TreeNode2 tn=node.parent.child;

	            while (tn.sibling != node)
	            {
	                tn = tn.sibling;
	            }

	            if (node.sibling != null)
	            {
	                tn.sibling = node.sibling;
	            }
	            else
	            {
	                tn.sibling = null;
	            }
	        }
	    }
	    else
	    {
	        if (node == rootNode)
	        {
	            if (node.sibling == null)
	            {
	                rootNode=null;
	            }
	            else
	            {
	                rootNode=node.sibling;
	            }
	        }
	        else
	        {
	            TreeNode2 tn = rootNode;

	            while (tn.sibling != node)
	            {
	                tn = tn.sibling;
	            }

	            if (node.sibling != null)
	            {
	                tn.sibling = node.sibling;
	            }
	            else
	            {
	                tn.sibling = null;
	            }
	        }
	    }

	    recount();
	    triggerRedraw ();
	}

	// print each node of TreeView2 beginning with node
	/**
	 * Print out the text of each node in the TreeView2 beginning with
	 * the given node.
	 * The nodes are printed out one per line with no indenting.
	 * @param node the first node to print
	 */
	public void printTree(TreeNode2 node)
	{
	    if (node==null)
	    {
	        return;
	    }

	    System.out.println(node.text);
	    printTree(node.child);
	    printTree(node.sibling);
	}

	private Vector e; // e is vector of existing nodes
	private void recount()
	{
	    count = 0;
	    e = new Vector();

	    if (rootNode != null)
	    {
	        rootNode.depth=0;
	        traverse(rootNode);
	    }
	}

	private void traverse(TreeNode2 node)
	{
	    count++;
	    e.addElement(node);

	    if (node.child != null)
	    {
	        node.child.depth = node.depth+1;
	        traverse(node.child);
	    }
	    if (node.sibling != null)
	    {
	        node.sibling.depth = node.depth;
	        traverse(node.sibling);
	    }
	}

	private Vector v; // v is vector of viewable nodes
	private void resetVector()
	{
		// Traverses tree to put nodes into vector v
		// for internal processing. Depths of nodes are set,
		// and viewCount and viewWidest is set.
		v = new Vector(count);
		viewWidest=30;

		if (count < 1)
		{
			viewCount = 0;
			return;
		}

		rootNode.depth=0;
		vectorize(rootNode,true,v);
		viewCount = v.size();
	}

	private void vectorize
			(TreeNode2	node,
			 boolean	respectExpanded,
			 Vector		nodeVector)
	{
	    if (node == null)
	        return;

	    nodeVector.addElement(node);

	    if ((!respectExpanded && node.child != null) || node.isExpanded())
	    {
	        node.child.depth = node.depth + 1;
	        vectorize(node.child,respectExpanded,nodeVector);
	    }

	    if (node.sibling != null)
	    {
	        node.sibling.depth = node.depth;
	        vectorize(node.sibling,respectExpanded,nodeVector);
	    }
	}

	private void debugVector()
	{
	    int vSize = v.size();

	    for (int i=0; i<count; i++)
	    {
	        TreeNode2 node = (TreeNode2) v.elementAt(i);
	        System.out.println(node.text);
	    }
	}

	// -----------------------------------------
	// --------- event related methods ---------
	// -----------------------------------------

    //class Adjustment implements AdjustmentListener
    //{
		public synchronized boolean handleEvent (Event event)
		{
                    if (event.target == verticalScrollBar)
			{
			    if (sbVPosition != verticalScrollBar.getValue())
			    {
				    sbVPosition = verticalScrollBar.getValue();
				    scrolled ();
			    }
                            return true;
			}
		    else if (event.target == horizontalScrollBar)
			{
			    if (sbHPosition != horizontalScrollBar.getValue())
			    {
				    sbHPosition = horizontalScrollBar.getValue();
				    repaint();
			    }
                            return true;
			}
                    else
                        return super.handleEvent (event);
		}
    //}

    //class Mouse extends MouseAdapter JDK1.1
    //{
	    /**
	     * Processes MOUSE_DOWN events.
	     * This is a standard Java AWT method which gets called by the AWT
	     * method handleEvent() in response to receiving a MOUSE_DOWN
	     * event. These events occur when the mouse button is pressed while
	     * inside this component.
	     *
	     * @param event the event
	     * @param x the component-relative horizontal coordinate of the mouse
	     * @param y the component-relative vertical coordinate of the mouse
	     *
	     * @return true if the event was handled
	     *
	     * @see java.awt.Component#mouseUp
	     * @see #handleEvent
	     */
		public boolean mouseDown (Event event, int x, int y)
		{
		    requestFocus();

                    //int x = event.getX(); JDK1.1
                    //int y = event.getY();

			int index = (y / cellSize) + sbVPosition;

			//If clicked below the last node
			if (index > viewCount-1)
				return true;

			TreeNode2 oldNode = selectedNode;
			TreeNode2 newNode = (TreeNode2)v.elementAt(index);
			int newDepth = newNode.getDepth();

			changeSelection(newNode);
			// check for toggle box click
			// todo: make it a bit bigger
			Rectangle toggleBox = new Rectangle(cellSize*newDepth + cellSize/4 - sbHPosition,
						                        (index-sbVPosition)*cellSize + clickSize/2,
						                        clickSize, clickSize);

			if (toggleBox.inside(x,y))
			{
				newNode.toggle();
				//sendActionEvent();
				triggerRedraw();
			}
			else
			{
				// check for double click
				if ((newNode==oldNode) && event.clickCount == 2)
				{
                                    //newNode.toggle();
                                    //triggerRedraw();
					sendActionEvent();
				}
				else
				{
					//single click action could be added here
                                    //timeMouseDown = event.getWhen();
				}

			}
                        return true;
		}
        //}

    //class Key extends KeyAdapter JDK1.1
    //{
	    /**
	     * Processes KEY_PRESS and KEY_ACTION events.
	     * This is a standard Java AWT method which gets called by the AWT
	     * method handleEvent() in response to receiving a KEY_PRESS or
	     * KEY_ACTION event. These events occur when this component has the focus
	     * and the user presses a "normal" or an "action" (F1, page up, etc) key.
	     *
	     * @param event the Event
	     * @param key the key that was pressed
	     * @return true if the event was handled
	     * @see java.awt.Component#keyUp
	     * @see #handleEvent
	     */
		public boolean keyDown(Event event, int key)
		{
		    int index = v.indexOf(selectedNode);

		    switch (key)
		    {
		        //case KeyEvent.VK_ENTER:    //enter key
		        case 13:
		            sendActionEvent();
		            requestFocus();
		            break;
		        case Event.LEFT:    //left arrow
		            if(event.controlDown())
                    {
	                    if(sbHPosition > 0)
                        {
                            horizontalScrollBar.setValue(Math.max(sbHPosition-=sbHLineIncrement,0));
                            repaint();
                        }
                        break;
	                }
	                else
		            if (selectedNode.isExpanded())
		            {
		                selectedNode.toggle();
		                triggerRedraw();
		                break;
		            }

		            // else drop through to "UP" with no "break;"
		        case Event.UP:
		            if (index > 0)
		            {
		                index--;
		                changeSelection((TreeNode2)v.elementAt(index));
		                requestFocus();
		            }
		            break;
		        case Event.RIGHT:
		            if(event.controlDown())
    	            {
	                    int max = horizontalScrollBar.getMaximum()-(isSun1_1?size().width-sbVWidth:0);
	                    if(sbHShow && sbHPosition < max)
                        {
                            horizontalScrollBar.setValue(Math.min(sbHPosition+=sbHLineIncrement, max));
                            repaint();
                        }
                        break;
	                }
	                else
		            if (selectedNode.isExpandable() && (!selectedNode.isExpanded()))
		            {
		                selectedNode.toggle();
		                //sendActionEvent();
		                triggerRedraw();
                                break;
		            }

		            if (!selectedNode.isExpandable())
		            {
                                break;
		            }
		            // else drop thru' to DOWN
		        case Event.DOWN:
		            if (index < viewCount-1)
		            {
		                index++;
		                changeSelection((TreeNode2)v.elementAt(index));
		                requestFocus();
                                break;
		            }
		            break;

                    default:
                        return false;
		    }
                    return true;
		}
	//}

//class Focus extends FocusAdapter JDK1.1
//{
        public boolean gotFocus (Event e, Object what)
        {
            hasFocus = true;
            if (selectedNode != null && v != null)
                drawNodeText(selectedNode,    (v.indexOf(selectedNode) - sbVPosition)*cellSize, true);
            return true;
        }

        public boolean focusLost(Event e, Object what)
        {
            hasFocus = false;
            if (selectedNode != null && v != null)
                drawNodeText(selectedNode,    (v.indexOf(selectedNode) - sbVPosition)*cellSize, true);
            return true;
        }
//}

	protected void sendActionEvent()
	{
            /*
		if (actionListener != null)
			actionListener.actionPerformed(new ActionEvent(this, ActionEvent.ACTION_PERFORMED, new String(selectedNode.getText())));
            */
            deliverEvent (new Event (this, Event.ACTION_EVENT, selectedNode.getText()));
	}

	/**
	 * Gets the currently selected node.
	 * @return the currently selected node, or null if none selected
	 */
	public TreeNode2 getSelectedNode()
	{
	    return selectedNode;
	}

	/**
	 * Gets the text of the currently selected node.
	 * @return the text of the currently selected node or null if no node
	 * is selected
	 */
	public String getSelectedText()
	{
	    if (selectedNode == null)
	        return null;

	    return selectedNode.getText();
	}

	protected void changeSelection(TreeNode2 node)
	{
	    if (node == selectedNode)
	        return;

	    TreeNode2 oldNode = selectedNode;
	    selectedNode = node;
	    drawNodeText(oldNode, (v.indexOf(oldNode) - sbVPosition)*cellSize, true);
	    drawNodeText(node,    (v.indexOf(node)    - sbVPosition)*cellSize, true);
	    // send select event

	    int index = v.indexOf(selectedNode);

            /* FIX: replace with SEL_CHANGED event?
		if (itemListener != null)
		{
			itemListener.itemStateChanged(new ItemEvent(this, ItemEvent.ITEM_STATE_CHANGED, oldNode, ItemEvent.DESELECTED));
			itemListener.itemStateChanged(new ItemEvent(this, ItemEvent.ITEM_STATE_CHANGED, selectedNode, ItemEvent.SELECTED));
		}
            */

	    if (index < sbVPosition)
	    { //scroll up
	        sbVPosition--;
	        verticalScrollBar.setValue(sbVPosition);
	        triggerRedraw();
	        return;
	    }

	    if (index >= sbVPosition + (viewHeight-cellSize/2)/cellSize)
	    {
	        sbVPosition++;
	        verticalScrollBar.setValue(sbVPosition);
	        triggerRedraw();
	        return;
	    }

	    repaint();
	}

	// -----------------------------------------
	// --------- graphics related methods ------
	// -----------------------------------------
    /**
     * Handles redrawing of this component on the screen.
     * This is a standard Java AWT method which gets called by the Java
     * AWT (repaint()) to handle repainting this component on the screen.
     * The graphics context clipping region is set to the bounding rectangle
     * of this component and its [0,0] coordinate is this component's
     * top-left corner.
     * Typically this method paints the background color to clear the
     * component's drawing space, sets graphics context to be the foreground
     * color, and then calls paint() to draw the component.
     *
     * It is overridden here to reduce flicker by eliminating the uneeded
     * clearing of the background.
     *
     * @param g the graphics context
     * @see java.awt.Component#repaint
     * @see #paint
     */
	public synchronized void update (Graphics g)
	{
	    //(eliminates background draw to reduce flicker)
	    paint(g);
	}

	/**
	 * Paints this component using the given graphics context.
     * This is a standard Java AWT method which typically gets called
     * by the AWT to handle painting this component. It paints this component
     * using the given graphics context. The graphics context clipping region
     * is set to the bounding rectangle of this component and its [0,0]
     * coordinate is this component's top-left corner.
     *
     * @param g the graphics context used for painting
     * @see java.awt.Component#repaint
     * @see #update
	 */
	public void paint (Graphics g)
	{
		Dimension d = size();
        if ((d.width != viewWidth) || (d.height != viewHeight))
            triggerRedraw ();

		if (redrawTriggered)
		{
			// redraw needed, or size has changed
			redraw(g);
		}
                /*
		//???RKM??? Is this really needed
		else if (java.beans.Beans.isDesignTime())
		{
			resetVector();
			newWidth = compWidth(g);
			drawTree();
		}
                */

		g.translate(-sbHPosition, 0);
                //g.clearRect(sbHPosition,0,d.width-sbVWidth,d.height-sbHHeight);
        if (sbVShow && sbHShow)
        {
            g.setColor(Color.lightGray);
            g.fillRect(sbHPosition+d.width-sbVWidth, d.height-sbHHeight, sbVWidth, sbHHeight);
        }
        g.clipRect(sbHPosition,0,d.width-sbVWidth,d.height-sbHHeight);
		g.drawImage(im1, 0, 0, this);
		g.setColor(Color.black);
        g.drawRect(sbHPosition,0, d.width-sbVWidth-1, d.height-sbHHeight-1);

	}

    /**
     * Lays out the vertical scrollbar as needed, then draws the TreeView2 into
     an offscreen image. This is used for cleaner refresh.
     */
    public void redraw()
    {
        //For backward compatibality. Do not allow to call only redraw() without recalculation.
        triggerRedraw();
    }

	public void redraw(Graphics g)
	{
	    boolean recalculate = treeChanged;
	    int inRectCount = 0;
	    
		redrawTriggered = false;
        treeChanged = false;
	    
        Dimension d = size();

        if (recalculate) {
            
    	    resetVector();

            newWidth = compWidth(g);

            inRectCount = ((d.height-sbHHeight)/cellSize);
    	    if (viewCount > inRectCount)
    	    {
      	        // need the vertical scrollbar
    	        sbVShow = true;
    	        sbVWidth = verticalScrollBar.preferredSize().width;
    	    }
    	    else
    	    {
      	        sbVShow = false;
    	        sbVWidth = 0;
    	        sbVPosition = 0;
    	    }

    	    if (newWidth > (d.width-sbVWidth))
    	    {
    	        // need the horizontal scrollbar
    	        sbHShow = true;
    			sbHHeight = horizontalScrollBar.preferredSize().height;
    	    }
    	    else
    	    {
    	        sbHShow = false;
                sbHHeight = 0;
                sbHPosition = 0;
    	    }

        }
        
        drawTree();

        if (recalculate) {
	        verticalScrollBar.setValues(sbVPosition, inRectCount, 0, viewCount-(isSun1_1?0:inRectCount));
			verticalScrollBar.setPageIncrement(inRectCount-1);

            horizontalScrollBar.setValues(sbHPosition, d.width-sbVWidth, 0, sbHSize-(isSun1_1?0:(d.width-sbVWidth)));
            horizontalScrollBar.setPageIncrement(d.width-sbVWidth);
            horizontalScrollBar.setLineIncrement(sbHLineIncrement);

    	    if (sbVShow)
    	    {
    	        verticalScrollBar.reshape(d.width-sbVWidth,0,sbVWidth,d.height-sbHHeight);
    	        verticalScrollBar.show();
    	    }
    	    else
    	    {
    	        verticalScrollBar.hide();
    	    }
        	
            if (sbHShow)
    	    {
    	        horizontalScrollBar.reshape(0,d.height-sbHHeight,d.width-sbVWidth,sbHHeight);
                horizontalScrollBar.show();
    	    }
    	    else
    	    {
    	        horizontalScrollBar.hide();
    	    }
        }
	}

    private int compWidth(Graphics gg)
    {
        int size = 0;
        int textOffset;
        TreeNode2 node;

   	    Font f = getFont();  //unix version might not provide a default font
		//Make certain there is a font
	    if (f == null)
	    {
	        f = new Font("TimesRoman", Font.PLAIN, 13);
	        gg.setFont(f);
	        setFont(f);
	    }

	    fm = gg.getFontMetrics();

        for (int i=0; i<v.size(); i++)
        {
            node = (TreeNode2)v.elementAt(i);
       	    textOffset = ((node.depth + 1) * (cellSize)) + cellSize + textInset - (node.getImage()==null ? 12:0);
       	    if (size < (textOffset+fm.stringWidth(node.text)+6))
    	        size = textOffset+fm.stringWidth(node.text)+6;
        }

        return size;
    }
    /**
     * Draws the TreeView2 into an offscreen image. This is used for cleaner refresh.
     */
	public void drawTree()
	{
		Dimension d = size();

		if ((d.width != viewWidth) || (d.height != viewHeight) || (g1==null) || (sbHSize!=newWidth))
		{
	        // size has changed, must resize image
			im1 = createImage(Math.max(sbHSize=newWidth, d.width), d.height);
			if (g1 != null) {
				g1.dispose();
			}
	        g1 = im1.getGraphics();
	        viewWidth=d.width;
	        viewHeight=d.height;
		}

	    Font f = getFont();  //unix version might not provide a default font

		//Make certain there is a font
	    if (f == null)
	    {
	        f = new Font("TimesRoman", Font.PLAIN, 13);
	        g1.setFont(f);
	        setFont(f);
	    }

	    //Make certain the graphics object has a font (Mac doesn't seem to)
		if (f != null)
		{
			if (g1.getFont() == null)
				g1.setFont(f);
		}

	    fm = g1.getFontMetrics();
	    g1.setColor(getBackground());
	    g1.fillRect(0, 0, im1.getWidth(this), d.height);// clear image

	    //do drawing for each visible node
	    int lastOne=sbVPosition+viewHeight/cellSize+1;

	    if (lastOne > viewCount)
	    {
	        lastOne = viewCount;
	    }

	    TreeNode2 outerNode = null;
	    if (!v.isEmpty())
	        outerNode = (TreeNode2)v.elementAt(sbVPosition);
	    for (int i=sbVPosition; i<lastOne; i++)
	    {
	        TreeNode2 node=(TreeNode2)v.elementAt(i);
	        int x = cellSize*(node.depth + 1);
	        int y = (i-sbVPosition)*cellSize;

	        // draw lines
	        g1.setColor(getForeground());

	        // draw vertical sibling line
	        if (node.sibling != null)
	        {
	            int k = v.indexOf(node.sibling) - i;

	            if (k > lastOne)
	            {
	                k = lastOne;
	            }

	            drawDotLine(x - cellSize/2, y + cellSize/2,
	                        x - cellSize/2, y + cellSize/2 +  k*cellSize);

	        }
	        // if sibling is above page, draw up to top of page for this level
	        for (int m=0; m<i; m++)
	        {
	            TreeNode2 sib = (TreeNode2)v.elementAt(m);

	            if ((sib.sibling == node) && (m<sbVPosition))
	            {
	                drawDotLine (x - cellSize/2, 0,
	                             x - cellSize/2, y + cellSize/2);
	            }
	        }

	        // draw vertical child lines
	        if (node.isExpanded())
	        {
	            drawDotLine(x + cellSize/2, y + cellSize -2 ,
	                        x + cellSize/2, y + cellSize + cellSize/2);
	        }
	        // draw node horizontal line
	        g1.setColor(getForeground());
	        drawDotLine(x - cellSize/2, y + cellSize/2,
	                    x + cellSize/2, y + cellSize/2);

	        // draw toggle box
	        if (node.isExpandable())
	        {
	            g1.setColor(getBackground());
	            g1.fillRect(cellSize*(node.depth) + cellSize/4, y + clickSize/2, clickSize, clickSize );
	            g1.setColor(getForeground());
	            g1.drawRect(cellSize*(node.depth) + cellSize/4, y + clickSize/2, clickSize, clickSize );
	            // cross hair
	            g1.drawLine(cellSize*(node.depth) + cellSize/4 +2,             y + cellSize/2,
	                        cellSize*(node.depth) + cellSize/4 + clickSize -2, y + cellSize/2);

	            if (!(node.isExpanded()))
	            {
	                g1.drawLine(cellSize*(node.depth) + cellSize/2, y + clickSize/2 +2,
	                            cellSize*(node.depth) + cellSize/2, y + clickSize/2 + clickSize -2);
	            }
	        }

	        // draw node image
	        Image nodeImage = node.getImage();

	        if (nodeImage != null)
	        {
	            g1.drawImage(nodeImage, x+imageInset, y, this);
	        }

	        // draw node text
	        if (node.text != null)
	        {
	            drawNodeText(node, y, /*node==selectedNode*/ true);
	        }

	        if(outerNode.depth>node.depth)
	            outerNode = node;
	    }

	    // draw outer vertical lines
	    if (outerNode!=null)
	    {
    	    while((outerNode = outerNode.parent) != null)
	        {
	            if (outerNode.sibling != null)
	                drawDotLine (cellSize*(outerNode.depth + 1) - cellSize/2, 0,
	                             cellSize*(outerNode.depth + 1) - cellSize/2, d.height);;
    	    }
        }
	}

	void drawNodeText(TreeNode2 node, int yPosition, boolean eraseBackground)
	{
	    Color fg, bg;
	    int depth=node.depth;
	    Image nodeImage = node.getImage();
	    int textOffset = ((depth + 1) * (cellSize)) + cellSize + textInset - (nodeImage==null ? 12:0);

	    /*
	    if (node == selectedNode && hasFocus)
	    {
	    	//??RKM?? Temp until these return some good values
                        //if (symantec.itools.lang.OS.isMacintosh())
				if (node.color != null)
				    fg = node.color;
				else
				    fg = Color.white;
                        //else
                                //fg = SystemColor.textHighlightText;

                        //if (symantec.itools.lang.OS.isMacintosh())
				bg = Color.black;
                        //else
				//bg = SystemColor.textHighlight;
	    }
	    */
	    if (node.color != null) {
	        fg = isLight (node.color) ? Color.black : Color.white;
            bg = node.color;
	    }
	    else {
	        fg = getForeground();
            bg = getBackground();
	    }

	    if (eraseBackground)
	    {
	        g1.setColor(bg);
	        g1.fillRect(textOffset-1, yPosition+1, fm.stringWidth(node.text)+4, cellSize-1);
	    }

        if (node == selectedNode)
        {
            g1.setColor(getForeground());
            g1.drawRect(textOffset-1, yPosition+1, fm.stringWidth(node.text)+3, cellSize-2);
            repaint(Math.max(0,textOffset-1-sbHPosition), yPosition+1, fm.stringWidth(node.text)+4, cellSize-1);
        }
	    g1.setColor(fg);
	    g1.drawString(node.text, textOffset, yPosition + cellSize - textBaseLine);
	}

	private boolean isLight (Color c) {
	    int r = c.getRed();
	    int g = c.getGreen();
	    int b = c.getBlue ();
	    
    	int min = (r < g) ? r : g;
    	if (b < min) 
    	    min = b;

    	return min > 128;
    }

	private void drawDotLine(int x0, int y0, int x1, int y1)
	{
	   if (y0==y1)
	   {
	        for (int i = x0; i<x1; i+=2)
	        {
	           g1.drawLine(i,y0, i, y1);
	        }
	    }
	    else
	    {
	        for (int i = y0; i<y1; i+=2)
	        {
	            g1.drawLine(x0, i, x1, i);
	        }
	    }
	}

	private void parseTreeStructure(String tempStructure[])
	    throws InvalidTreeNode2Exception
	{
		for(int i = 0; i < tempStructure.length; i++)
		{
			String entry = tempStructure[i];
			int indentLevel = findLastPreSpace(entry)/*+1*/;

			if (indentLevel == -1)
				throw new InvalidTreeNode2Exception();

			TreeNode2 node = new TreeNode2(entry.trim());
			node.setDepth(indentLevel);

			if (rootNode == null)
			{
				if (indentLevel != 0)
					throw new InvalidTreeNode2Exception();

				append(node);
			}
			else
			{
				TreeNode2 currentNode = rootNode;
                while(currentNode.sibling != null)
    				currentNode = currentNode.sibling;

				for(int j = 1; j < indentLevel; j++)
				{
					int numberOfChildren = currentNode.numberOfChildren;
					TreeNode2 tempNode = null;

					if (numberOfChildren > 0)
					{
						tempNode = currentNode.child;

						while(tempNode.sibling != null)
							tempNode = tempNode.sibling;
					}

					if (tempNode != null)
						currentNode = tempNode;
					else
						break;
				}

				int diff = indentLevel - currentNode.getDepth();

				if (diff > 1)
					throw new InvalidTreeNode2Exception();

				if (diff == 1)
					insert(node, currentNode, CHILD);
				else
					insert(node, currentNode, NEXT);
			}
		}
	}

	private int findLastPreSpace(String s)
	{
	    int length;

	    length = s.length();

	    if(s.charAt(0) != ' ' && s.charAt(0) != '\t')
	    {
	        return 0;
	    }

	    for(int i = 1; i < length; i++)
	    {
	        if(s.charAt(i) != ' ' && s.charAt(i) != '\t')
	        {
	            return i;
	        }
	    }

	    return -1;
	}

    /**
	 * Returns the recommended dimensions to properly display this component.
     * This is a standard Java AWT method which gets called to determine
     * the recommended size of this component.
     *
     * @see #minimumSize
	 */
	public synchronized Dimension preferredSize()
	{
	    //???RKM??? This is bogus, shouldn't this have something to do with the data ???
	    return new Dimension(175, 125);
	}

    /**
	 * Returns the minimum dimensions to properly display this component.
     * This is a standard Java AWT method which gets called to determine
     * the minimum size of this component.
     *
     * @see #preferredSize
	 */
	public synchronized Dimension minimumSize()
	{
	    return new Dimension(50, 50);
	}

	/**
	 * Takes no action.
	 * This is a standard Java AWT method which gets called to specify
	 * which layout manager should be used to layout the components in
	 * standard containers.
	 *
	 * Since layout managers CANNOT BE USED with this container the standard
	 * setLayout has been OVERRIDDEN for this container and does nothing.
	 *
	 * @param lm the layout manager to use to layout this container's components
	 * (IGNORED)
	 * @see java.awt.Container#getLayout
	 **/
	public void setLayout(LayoutManager lm)
	{
	}

	/**
	 * Tells this component that it has been added to a container.
	 * This is a standard Java AWT method which gets called by the AWT when
	 * this component is added to a container. Typically, it is used to
	 * create this component's peer.
	 *
	 * It has been overridden here to hook-up event listeners.
	 *
	 * @see #removeNotify
	 */
                /* JDK1.1
		//Hook up listeners
	public synchronized void addNotify()
	{
		super.addNotify();

		if (mouse == null)
		{
			mouse = new Mouse();
			addMouseListener(mouse);
		}
		if (key == null)
		{
			key = new Key();
			addKeyListener(key);
		}
		if (adjustment == null)
		{
			adjustment = new Adjustment();
			verticalScrollBar.addAdjustmentListener(adjustment);
			horizontalScrollBar.addAdjustmentListener(adjustment);
		}
		if (focus == null)
		{
			focus = new Focus();
			addFocusListener(focus);
		}

	}
                */

	/**
	 * Tells this component that it is being removed from a container.
	 * This is a standard Java AWT method which gets called by the AWT when
	 * this component is removed from a container. Typically, it is used to
	 * destroy the peers of this component and all its subcomponents.
	 *
	 * It has been overridden here to unhook event listeners.
	 *
	 * @see #addNotify
	 */
            /*JDK1.1
	public synchronized void removeNotify()
	{
		//Unhook listeners
		if (mouse != null)
		{
			removeMouseListener(mouse);
			mouse = null;
		}
		if (key != null)
		{
			removeKeyListener(key);
			key = null;
		}
		if (adjustment != null)
		{
			verticalScrollBar.removeAdjustmentListener(adjustment);
			horizontalScrollBar.removeAdjustmentListener(adjustment);
			adjustment = null;
		}
        if (focus != null)
		{
			removeFocusListener(focus);
			focus = null;
		}
		super.removeNotify();
	}
            */

    /**
     * Adds the specified action listener to receive action events
     * from this button.
     * @param l the action listener
     */
    /* JDK1.1
	public void addActionListener(ActionListener l)
	{
		actionListener = AWTEventMulticaster.add(actionListener, l);
	}
    */

    /**
     * Removes the specified action listener so it no longer receives
     * action events from this button.
     * @param l the action listener
     */
    /* JDK1.1
	public void removeActionListener(ActionListener l)
	{
		actionListener = AWTEventMulticaster.remove(actionListener, l);
	}
    */

    void scrolled ()
    {
		redrawTriggered = true;
		repaint();
    }
    
	protected void triggerRedraw()
	{
		redrawTriggered = true;
		treeChanged = true;
		repaint();
	}

	// Private members
    /* JDK1.1
	protected Key key = null;
	protected Mouse mouse = null;
	protected Adjustment adjustment = null;
        protected ActionListener actionListener = null;
        protected ItemListener itemListener = null;
        protected Focus focus = null;
    */

	protected boolean redrawTriggered = false;
	protected boolean treeChanged = false;
	protected boolean hasFocus = false;
}

class InvalidTreeNode2Exception
    extends Exception
{
}
