/*
 * WebSPHINX web crawling toolkit
 * Copyright (C) 1998,1999 Carnegie Mellon University 
 * 
 * This library is free software; you can redistribute it
 * and/or modify it under the terms of the GNU Library
 * General Public License as published by the Free Software 
 * Foundation, version 2.
 *
 * WebSPHINX homepage: http://www.cs.cmu.edu/~rcm/websphinx/
 */
package websphinx.util;
import java.util.Enumeration;
import java.util.NoSuchElementException;

/**
 * Enumeration of an arbitrary array.
 */
public class ArrayEnumeration implements Enumeration {
    Object[] array;
    int i = 0;

    /**
     * Make an ArrayEnumeration.
     * @param array Array to enumerate.  May be null, if desired.  
     * (This is sometimes useful for producing an empty enumeration.)
     */
    public ArrayEnumeration (Object[] array) {
        this.array = array;
    }

    /**
     * Test if enumeration has reached end.
     * @return true if more elements are available to be enumerated, false
     * if all elements have been yielded by nextElement()
     */
    public boolean hasMoreElements () {
        return array != null ? i < array.length : false;
    }

    /**
     * Get next element of enumeration.
     * @return next element of enumeration, advancing the enumeration pointer
     * @exception java.util.NoSuchElementException if no more elements
     */
    public Object nextElement () {
        if (array == null || i >= array.length)
            throw new NoSuchElementException ();
        return array[i++];
    }
}
