/*
 * WebSPHINX web crawling toolkit
 * Copyright (C) 1998,1999 Carnegie Mellon University 
 * 
 * This library is free software; you can redistribute it
 * and/or modify it under the terms of the GNU Library
 * General Public License as published by the Free Software 
 * Foundation, version 2.
 *
 * WebSPHINX homepage: http://www.cs.cmu.edu/~rcm/websphinx/
 */
package websphinx.searchengine;

import websphinx.*;
import java.net.URL;

/**
 * Abstract representation of a search engine.
 */
public interface SearchEngine extends Classifier {
    /**
     * Make a query URL for this search engine.
     * @param keywords list of keywords, separated by spaces
     * @return URL that submits the keywords to this search engine
     */
    public URL makeQuery (String keywords);

    /**
     * Get number of results per page for this search engine.
     * @return typical number of results per page
     */
    public int getResultsPerPage ();
}
