/*
 * WebSPHINX web crawling toolkit
 * Copyright (C) 1998,1999 Carnegie Mellon University 
 * 
 * This library is free software; you can redistribute it
 * and/or modify it under the terms of the GNU Library
 * General Public License as published by the Free Software 
 * Foundation, version 2.
 *
 * WebSPHINX homepage: http://www.cs.cmu.edu/~rcm/websphinx/
 */
package websphinx;

/**
 * Tagless text regions on an HTML page.
 */
public class Text extends Region {

    String text;

    /**
     * Make a Text.
     * @param page Page containing region
     * @param start Starting offset of region in page
     * @param end Ending offset of region
     * @param text Text of which region consists
     */
    public Text (Page page, int start, int end, String text) {
        super (page, start, end);
        this.text = text;
    }

    /**
     * Returns the region's tagless text
     * @return a string consisting of the text in the page contained by this region
     */
    public String toText () {
        return text;
    }
}
