/*
 * WebSPHINX web crawling toolkit
 * Copyright (C) 1998,1999 Carnegie Mellon University 
 * 
 * This library is free software; you can redistribute it
 * and/or modify it under the terms of the GNU Library
 * General Public License as published by the Free Software 
 * Foundation, version 2.
 *
 * WebSPHINX homepage: http://www.cs.cmu.edu/~rcm/websphinx/
 */
package websphinx;

import java.util.Enumeration;

public abstract class PatternMatcher implements Enumeration {
    Region match = null;
    boolean yielded = true;

    public boolean hasMoreElements () {
        if (yielded) {
            match = findNext ();
            yielded = false;
        }
        return match != null;
    }

    public Object nextElement () {
        return nextMatch ();
    }

    public Region nextMatch () {
        if (!yielded) {
            yielded = true;
            return match;
        }
        match = findNext ();
        return match;
    }

    protected abstract Region findNext ();

}

