/*
 * WebSPHINX web crawling toolkit
 * Copyright (C) 1998,1999 Carnegie Mellon University 
 * 
 * This library is free software; you can redistribute it
 * and/or modify it under the terms of the GNU Library
 * General Public License as published by the Free Software 
 * Foundation, version 2.
 *
 * WebSPHINX homepage: http://www.cs.cmu.edu/~rcm/websphinx/
 */
package websphinx;
/**
 * Classifier interface.  A classifier is a helper object that annotates
 * pages and links with labels (using Page.setLabel() and Link.setLabel()).
 * When a page is retrieved by a crawler, it is passed to the classify()
 * method of every Classifier registered with the crawler.  Here are some
 * typical uses for classifiers:
 * <UL>
 * <LI> classifying links into categories like child or parent (see
 *  websphinx.StandardClassifier);
 * <LI> classifying pages into categories like biology or computers;
 * <LI> recognizing and parsing pages formatted in a particular style, such as
 *      AltaVista, Yahoo, or latex2html (e.g., the search engine classifiers
 *      in websphinx.searchengine)
 * <LI>
 * </UL>
 */
public interface Classifier 
//#ifdef JDK1.1 
extends java.io.Serializable 
//#endif JDK1.1
{
    /** 
     * Classify a page.  Typically, the classifier calls page.setLabel() and
     * page.setField() to mark up the page.  The classifier may also look
     * through the page's links and call link.setLabel() to mark them up.
     * @param page Page to classify
     */
    public abstract void classify (Page page);
    
    /** 
     * Get priority of this classifier.  Lower priorities execute first.
     * A classifier should also define a public constant <CODE>priority</CODE>
     * so that classifiers that depend on it can compute their 
     * priorities statically.  For example, if your classifier
     * depends on FooClassifier and BarClassifier, you might set your
     * priority as:
     * <PRE>
     * public static final float priority = Math.max (FooClassifier, BarClassifier) + 1;
     * public float getPriority () { return priority; }
     * </PRE>
     * 
     * @return priority of this classifier
     */
    public float getPriority ();    
}
