 function clase_4_equilibrio_fusion
% Este archivo contiene ejemplos de cristalizacin
clc
format short
close all
% ejemplo 1, problema directo, FA p479
titulo='Fusin en equilibrio en el Manto'
% Una peridotita tiene:
C0=[2500;1500;0.2; 0.01]% Ni, Cr, Yb Rb
% si el resido de ol, cpx es:
f=[60;40]/100
% cual es Cl?
% use 
K=[6 1; 1 8; 0.1 0.3 ;0 0]

% Solucion
D=K*f
c=0;
for F=0:0.1:1;
    c=c+1;
    Cl(:,c)=C0./(F+(1-F)*D);
end
figure 
plot(C0(1)/C0(2),C0(3)/C0(4),'ro',...
    Cl(1,:)./Cl(2,:),Cl(3,:)./Cl(4,:),'bx-')
legend('Peridotita C0','Residuos Basalticos')
xlabel('Ni/Cr')
ylabel('Yb/Rb')
c=0;
title(titulo)
for F=0:0.1:1;
    c=c+1;
    Cl(1,c)./Cl(2,c);
   text(0.002+Cl(1,c)./Cl(2,c),Cl(3,c)./Cl(4,c),[num2str(F*100) '%']);
end


% ejemplo 2, problema inverso, FA 481
% Suponga un Cl
Cl=[676;426;0.763;0.1]
% Obtenga las proporciones minerales y la tasa de Fusion

K2=[1 6 1; 1 1 8; 1 0.1 0.3 ; 1 0 0];
n=3% minerales
m=4% componentes
for j=1:n
    for i=1:m
        A(i,j)=K2(i,j)*Cl(i)
    end
end

X0=(A'*A)^-1*A'*C0
F=X0(1,1);
fol=X0(2)/(1-F)
fcpx=X0(3)/(1-F)
disp(['hay un ' num2str(F*100) '% de fusin en equilibrio'])
disp(['con un residuo constituido por: '])
disp([num2str(fol*100) '% de olivino y ' num2str(fcpx*100) '% de clinopiroxeno'])
hold on
plot(Cl(1,1)./Cl(2,1),Cl(3,1)./Cl(4,1),'go')
legend('Peridotita C0','Residuos Basalticos', 'Basalto F=10%; ol=60%; cpx=40%')

% ejemplo 3, problema directo, fusin fraccionada
titulo='Fusin en equilibrio v/s fraccionada en el Manto'
% Una peridotita tiene:
C0=[2500;1500;0.2; 0.01]% Ni, Cr, Yb Rb
% si el resido de ol, cpx es:
f=[60;40]/100
% cual es Cl?
% use 
K=[6 1; 1 8; 0.1 0.3 ;0.0001 0.0001]

% Solucion 
D=K*f
c=0;
m=4
for F=0:0.1:1;
    c=c+1;
    for i=1:m
        Cl(i,c)=C0(i)/D(i)*((1-F)^(1/D(i)-1));
        Cl_med(i,c)=C0(i)/F*(1-(1-F)^(1/D(i)));
    end
end
Cl
hold on 
plot(Cl_med(1,:)./Cl_med(2,:),Cl_med(3,:)./Cl_med(4,:),'mx-')
legend('Peridotita C0','Residuos Basalticos', 'Basalto F=10%; ol=60%; cpx=40%','Fusin Parcial (media)')
xlabel('Ni/Cr')
ylabel('Yb/Rb')
c=0;
title(titulo)
for F=0:0.1:1;
    c=c+1;
   text(0.002+Cl_med(1,c)./Cl_med(2,c),Cl_med(3,c)./Cl_med(4,c),[num2str(F*100) '%'])
end



% Ejemplo 4, cual es la diferencia entre fusin en 
% equilibrio y parcial para elementos incompatibles
% y compatibles, i.e. D<<1 y D>>1, respectivamente?
D=[0.1; 2]
F=0:0.1:1
c=0;
m=2
for F=0:0.1:1;
    c=c+1;
    for i=1:m
        R_eq(i,c)=1/(F+D(i)*(1-F)); % R=Cl/C0
        R_par(i,c)=1/D(i)*((1-F)^(1/D(i)-1)); % R=Cl/C0
    end
end
F=0:0.1:1
figure
plot(F,R_eq,'rx-',...
    F,R_par,'bx-')
legend('equilibrio','equilibrio','parcial','parcial')
text(0.1,5,'D=0.1')
text(0.1,1,'D=2')
xlabel('F, fraccion en peso del liquido residual')
ylabel('C_l/C_0')

% Conclusion: Las ecuaciones difieren para elementos incompatibles a 
% altas tasas de fusion, pero son similares en elementos incompatibles


% Ejemplo 5, Fusion en eq con la formulacion de Shaw, P 490 FA
% Una peridotita tiene:
C0=[2500;1500;0.2; 0.01]% Ni, Cr, Yb Rb (igual a los ejemplos anteriores)
% si el resido de ol, cpx es sigue una norma 40 ol y 60 cpx (fusion en el eutectico)
% cual es Cl?
% use 
K=[6 1; 1 8; 0.1 0.3 ;0 0]

% Solucion
D0=K*[0.8 0.2]'
P=K*[0.4 0.6]'
% P=K*[0.8 0.2]'
c=0;
m=4;
for F=0:0.1:1;
    c=c+1;
    Cl_shaw_eq(:,c)=C0./(D0+(1-P).*F);
    Cl_eq(:,c)=C0./(F+(1-F)*D0);%    Cl(:,c)=C0./(F+(1-F)*D)
    for i=1:m
        if P(i)==0
            P(i)=1e-18;
        end
        if D0(i)==0
            D0(i)=1e-18;
        end
        Cl_par(i,c)=C0(i)/F*(1-(1-F)^(1/D0(i))); %media
        Cl_shaw_par(i,c)=C0(i)/F*(1-(1-F*P(i)/D0(i))^(1/P(i)));
    end
end
figure 
plot(C0(1)/C0(2),C0(3)/C0(4),'ro',...
    Cl_shaw_eq(1,:)./Cl_shaw_eq(2,:),Cl_shaw_eq(3,:)./Cl_shaw_eq(4,:),'bx-',...
    Cl_eq(1,:)./Cl_eq(2,:),Cl_eq(3,:)./Cl_eq(4,:),'mx-',...
    Cl_shaw_par(1,:)./Cl_shaw_par(2,:),Cl_shaw_par(3,:)./Cl_shaw_par(4,:),'gx-',...
    Cl_par(1,:)./Cl_par(2,:),Cl_par(3,:)./Cl_par(4,:),'rx-')
legend('Peridotita C0','Cl en eq, Shaw','Cl en eq','Cl_{media} parcial, Shaw','Cl_{media} parcial')
xlabel('Ni/Cr')
ylabel('Yb/Rb')
c=0;
title('Modelos de Fusin')
for F=0:0.1:1;
    c=c+1;
   text(0.002+ Cl_shaw_eq(1,c)./Cl_shaw_eq(2,c),Cl_shaw_eq(3,c)./Cl_shaw_eq(4,c),[num2str(F*100) '%'])
   text(0.002+ Cl_eq(1,c)./Cl_eq(2,c),Cl_eq(3,c)./Cl_eq(4,c),[num2str(F*100) '%'])
end
