%Integrates six box, time-dependent coupled atmosphere-ocean- sea-ice model 
%including specifiedgreenhouse gas forcing, sensible and latent heat 
%transports in the atmosphere, fresh water ransport in the atmosphere, 
%thermohaline and wind driven circulation heat transports in the ocean 
%and density-difference dependent vertical exchange between ocean surface
% and deep layers. Change parameters r to simulate effects of changed 
%atmospheric CO2 concentration 

%September 2006, Gary Shaffer

clear all; 
opengl neverselect

%load yo
% Set initial values yo(1:5)
%    pCO2  Tsw Tsc Sw  Sc
yo=[280e-9  28  2  35  35];
y=yo; 

global Soc Ofr HHA fd Sm cp rho sy Tf Lv Va Q10 del Tref


Soc   = 1365;         %present day solar constant, W/m2
Ofr  =  0.3;      % Land to total area fraction
rad  =  6.371e6;  % Earth radius
HHA   =  pi*rad^2; % Half Hemispheric area
fd   =  30*pi/180;     % Dividing Latitude
Sm   =  35.;      % Mean salinity
cp   =  4e3;      % Heat capacity
rho  = 1.028e3;     %mean density of seawater, kg/m3
sy   = 31536000;  % Seconds pr. year 
Lv   = 2.25e6*1e3;% Latent heat of vaporization [J/1000kg] = [J/m^3]
Tf   = -1.8;
Q10  = 2;
Tref = 15;

Volc=7e4;             %Volcanic input, st.val 7e4 mol/s 
del=0.9;%0.45;             %fraction of total land at low latitude, modern
                      %day value is about 0.45
                           
delSc=0.02;             %Sc is the solar constant divided by So, st. val 0.005
j=31;                  %total stable steady state solution number, st. val 350 
Scmax=1.3;             %maximum Sc, st. val 1.5  

for m = 1:j             %stepping over different values of F 

Q   =  Soc*(Scmax-delSc*(m-1));             %solar constant, i.e F*So

Q/Soc
pCO2=y(1);Tsw=y(2);Tsc=y(3);Sw=y(4);Sc=y(5);

r=5000;
for p=1:r

[W,Ha,Ho,F,fiout,q,v,Tsw,Tsc,TLNI,THNI,Sw,Sc]=...
    SilWeafunc(pCO2,Q,Tsw,Tsc,Sw,Sc);

dpCO2 = 1e-5*pCO2*(Volc-W); 
if abs(Volc-W)<1e1 break; end
pCO2 = pCO2+dpCO2;
end

y=[pCO2 Tsw Tsc Sw Sc];

sQ(m)=Q;
pCO2out(m)=pCO2;
Tswout(m)=Tsw;Tscout(m)=Tsc; 
Tm(m)=(Tsw+Tsc)/2;
TLNIout(m)=TLNI;THNIout(m)=THNI;
Swout(m)=Sw;Scout(m)=Sc;
fidegout(m)=fiout*180/pi;
qout(m)=q;vout(m)=v;
Haout(m)=Ha;Hwout(m)=Ho;
Fcout(m)=F;
end
%save results for plotting
             

% Plot time dependent solution 

%scrsz = get(0,'ScreenSize');
%figure('Position',[1 scrsz(4)/1.5 scrsz(3)/1.2 scrsz(4)/1.2]);hold on

subplot(2,4,1)   %global mean surface temperature
hold on
title('Mean global temperature')
plot(sQ(:)/Soc,Tm(:),'k-')
xlabel('Scaled So')

subplot(2,4,2)   %atmosphere and ocean box temperatures
hold on
title('T [^oC]')
plot(sQ(:)/Soc,Tswout(:),'r')
plot(sQ(:)/Soc,Tscout(:),'b')
plot(sQ(:)/Soc,TLNIout(:),'g--')
plot(sQ(:)/Soc,THNIout(:),'g--')
xlabel('Scaled So')

subplot(2,4,3)   %pC02
hold on
title('pCO2')
plot(sQ(:)/Soc,log10(pCO2out(:)),'r-')
plot(sQ(:)/Soc,log10(280e-6),'g:')
plot(sQ(:)/Soc,log10(10e-6),'g:')
plot(1,log10(pCO2out(:)),'g-')
xlabel('Scaled So')

subplot(2,4,4)   %Ocean and atmospheric heat transports
hold on
title('Ho, Ha, Ho+Ha [PW]')
plot(sQ(:)/Soc,Hwout(:),'r-')
plot(sQ(:)/Soc,Haout(:),'b:')
plot(sQ(:)/Soc,(Hwout(:)+Haout(:)),'k')
xlabel('Scaled So')
     
subplot(2,4,5)  %Ice/snow line latitude
hold on
title('Ice/snow line latitude')
plot(sQ(:)/Soc,fidegout(:),'b-')
xlabel('Scaled So')

subplot(2,4,6)  %ocean box salinities
hold on
title('S')
plot(sQ(:)/Soc,Swout(:),'r')
plot(sQ(:)/Soc,Scout(:),'b')
xlabel('Scaled So')
     
subplot(2,4,7)  %thermohaline and "wind-driven" circulation" 
hold on         % exchange (v)
title('q(blue), v (red) [Sv]')
plot(sQ(:)/Soc,qout(:),'b-')
plot(sQ(:)/Soc,vout(:),'r-')
xlabel('Scaled So')  
     
subplot(2,4,8) %Atmospheric moisture transport across the dividing latitude
hold on
title('F [Sv]')
plot(sQ(:)/Soc,Fcout(:),'r-')
xlabel('Scaled So')

hold on
 