%Integrates six box, time-dependent coupled atmosphere-ocean- sea-ice model 
%including specifiedgreenhouse gas forcing, sensible and latent heat 
%transports in the atmosphere, fresh water ransport in the atmosphere, 
%thermohaline and wind driven circulation heat transports in the ocean 
%and density-difference dependent vertical exchange between ocean surface
% and deep layers. Change parameters r to simulate effects of changed 
%atmospheric CO2 concentration 

%September 2006, Gary Shaffer

clear all; 
opengl neverselect

global So Ofr HHA fd Sm cp rho sy Tf Lv Va Q10 del Tref Q pCO2...
    Tsw Tsc Sw Sc

%load yo
% Set initial values yo(1:5)
%    pCO2  Tsw Tsc Sw  Sc
yo=[280e-7  28  2  35  35];
y=yo; 
pCO2=y(1);Tsw=y(2);Tsc=y(3);Sw=y(4);Sc=y(5);

Soc   = 1365;         %present day solar constant, W/m2
Ofr  =  0.3;      % Land to total area fraction
rad  =  6.371e6;  % Earth radius
HHA   =  pi*rad^2; % Half Hemispheric area
fd   =  pi/6;     % Dividing Latitude
Sm   =  35.;      % Mean salinity
cp   =  4e3;      % Heat capacity
rho  = 1.028e3;       %mean density of seawater, kg/m3
sy   = 31536000;  % Seconds pr. year 
Lv   = 2.25e6*1e3;% Latent heat of vaporization [J/1000kg] = [J/m^3]
Va   = 1.733e20/2; %atmospheric volume (one hemisphere) [mol/atm 
Tf   = -1.8;
Q10  = 2.0;
Tref = 15;

Volc=7e4;             %Volcanic input, st.val 7e4 mol/s 
so=0.94;                       %multiple of present day solar constant, st. val 0.94
del=0.9;                  %fraction of total land at low latitude, modern
                           %day value is about 0.45
% Integration
%------------------------------
%--------------------------------------------
tend   =30000;    % End-time of integration [kyr]
dtout  = 10;    % Output interval [kyr]
ts      = 10;   % Timestep [kyr], st val 1/25
dt    = ts*sy*1e3;  % Timestep [sec]
t     = 0;
for c =1:tend/dtout
  for cc=0:dt:(dtout*sy*1e3-dt)
   
      t=t+dt;
if c == 0.15*tend/dtout
s=0.7;
else
s=so;    
end 
Q=s*Soc;     

[W,Ha,Ho,F,fiout,q,v,Tsw,Tsc,TLNI,THNI,Sw,Sc]=...
    SilWeafunc(pCO2,Q,Tsw,Tsc,Sw,Sc);

dpCO2 = dt*1/Va *(Volc-W); 
pCO2 = pCO2+dpCO2;

  end

%save results for plotting

time(c)=c*dtout;  
pCO2out(c)=pCO2;
Tswout(c)=Tsw;Tscout(c)=Tsc; 
TLNIout(c)=TLNI;THNIout(c)=THNI;
Swout(c)=Sw;Scout(c)=Sc;
fidegout(c)=fiout*180/pi;
qout(c)=q;vout(c)=v;
Haout(c)=Ha;Hwout(c)=Ho;
Fcout(c)=F;
Wout(c)=W;
(Tsw+Tsc)/2
end

%Save final values of a run to use as initial values for the next run 
                                      %
yo=[pCO2 Tsw Tsc Sw Sc];
save yo                              

% Plot time dependent solution 

%scrsz = get(0,'ScreenSize');
%figure('Position',[1 scrsz(4)/1.5 scrsz(3)/1.2 scrsz(4)/1.2])

subplot(2,4,1)   %global mean surface temperature
hold on
title('Atmospheric temperatures')
plot(time(1:tend/dtout),(Tswout(1:tend/dtout)+Tscout(1:tend/dtout))/2,'k-')
plot(time(1:tend/dtout),Tswout(1:tend/dtout),'r')
plot(time(1:tend/dtout),Tscout(1:tend/dtout),'b')
xlabel('t [kyr]')

subplot(2,4,2)   %pC02
hold on
title('pCO2')
plot(time(1:tend/dtout),log10(pCO2out(1:tend/dtout)),'r-')
plot(time(1:tend/dtout),log10(280e-6),'g:')
plot(time(1:tend/dtout),log10(10e-6),'g:')
xlabel('t [kyr]')

subplot(2,4,3)  %ocean box salinities
hold on
title('Salinity')
plot(time(1:tend/dtout),Swout(1:tend/dtout),'r')
plot(time(1:tend/dtout),Scout(1:tend/dtout),'b')
xlabel('t [kyr]')


subplot(2,4,4)   %Ocean and atmospheric heat transports
hold on
title('Heat transports [PW]')
plot(time(1:tend/dtout),Hwout(1:tend/dtout),'r-')
plot(time(1:tend/dtout),Haout(1:tend/dtout),'b:')
plot(time(1:tend/dtout),(Hwout(1:tend/dtout)+Haout(1:tend/dtout)),'k')
xlabel('t [kyr]')
     
subplot(2,4,5)  %Ice/snow line latitude
hold on
title('Ice/snow line latitude')
plot(time(1:tend/dtout),fidegout(1:tend/dtout),'b-')
xlabel('t [kyr]')

subplot(2,4,6)   %Scaled Weathering
hold on
title('Scaled weathering')
plot(time(1:tend/dtout),Wout(1:tend/dtout)/Volc,'r-')
xlabel('t [kyr]')

     
subplot(2,4,7)  %thermohaline and "wind-driven" circulation" 
hold on         % exchange (v)
title('q(blue), v (red) [Sv]')
plot(time(1:tend/dtout),qout(1:tend/dtout),'b-')
plot(time(1:tend/dtout),vout(1:tend/dtout),'r-')
xlabel('t [kyr]')  
     
subplot(2,4,8) %Atmospheric moisture transport across the dividing latitude
hold on
title('F [Sv]')
plot(time(1:tend/dtout),Fcout(1:tend/dtout),'r-')
xlabel('t [yr]')
 
