%Simple two box, thermohaline circulation model
%version including the effects of the wind-driven circulation, represented
%by horizontal exchange parameter v

clear all

load standardcaseTHC2007

cp   = 4.0e3;         %specific heat capacity of water, J/kg*C
rho  = 1.028e3;       %mean density of seawater, kg/m3

alfa     = 0.2e-3;           %thermal expansion coefficient
beta     = 0.8e-3;           %salinity contraction coefficient
Sm      = 35.0;              %ocean mean salinity
delT    = 22.2;              %st. val Tow-Toc = 22.2
k       = 0.244e-3;         %flow parameter, scaled to give about 15 Sv
                            %THC flow in st. case for v = 5, st. val.0.244e-3
                                    
v       = 5;                     %effective exchange from "wind-driven
                                 %circulation, in Sv, st. val 5            

delS=0;                           %initial guess for salinity difference,
                                  %Sow-Soc                                                                  
                                                                             
delF=0.005;           %F is the atmospheric moisture transport across 30 
                      % degree latitude, in Sv
j=800;                %total number of stable steady state solutions 
n = 5000;             %maximum number of interations
Fmin=-0.2;            %minimum F (F positive for moisture transport from
                      %the warm to the cold box

for m = 1:j           %stepping over different values of F 

if m<j/2
F   =  Fmin+delF*(m-1);   
else
F   =  Fmin+delF*j-delF*(m-1); 
end

for i=1:n             %iteration to find stable steady states
   
q  =  (alfa*delT-beta*delS)/k;
delSn=F*Sm/(abs(q)+v);
delS=delS-(delS-delSn)/500;
Err = ((delS-delSn)^2)^0.5;

if Err<1e-3 break; end
end

%Ocean energy transports
                             
Hq =  rho*cp*abs(q)*delT*1e6;                         %[W]
Hv =  rho*cp*v*delT*1e6;                              %[W]

%print thermohaline circulation and ocean heat 
%transport for prescribed fresh water forcing 

if F==0.7              
    THC=q                                            %[Sv]
    OcHeatTrans =(Hq+Hv)/1e15                        %[pW]
end    

sF(m) =F;                                             %[Sv] 
sq(m)= q;                                             %[Sv]
hq(m)=Hq/1e15;                                        %[pW]
hv(m)=Hv/1e15;                                        %[pW] 


%run to create standcase files

%sFs(m)=F;sqs(m)=q;hqs(m)=Hq/1e15;hvs(m)=Hv/1e15;

end

%save('standardcaseTHC2006', 'sFs', 'sqs','hqs','hvs','-v6') 

figure (1); hold on              %Plots stable steady state THC and
                                 %ocean heat transports as a function of F 
 
subplot(2,1,1)
plot(sF(:),sq(:),'r','LineWidth',2); hold on
plot(sFs(:),sqs(:),'b','LineWidth',2); 
plot(Fmin:0.01:(Fmin+delF*j/2),0,'g:');
plot(0.7,-5:0.3:20,'g:');
xlabel('Atmosphere moisture transport (Sv)');
ylabel('Thermohaline circulation (Sv)')



subplot(2,1,2)                      
plot(sF(:),hq(:)+hv(:),'r','LineWidth',2); hold on
plot(sFs(:),hqs(:)+hvs(:),'b','LineWidth',2);
plot(0.7,0:0.03:2.5,'g');
xlabel('Atmosphere moisture transport (Sv)');
ylabel('Total ocean heat transports(THC+WDC; PW)')
%-------------