(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9600,        227]
NotebookOptionsPosition[      9238,        210]
NotebookOutlinePosition[      9575,        225]
CellTagsIndexPosition[      9532,        222]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Problema", " ", "del", " ", "Rio"}], "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"L", "[", 
    RowBox[{"a_", ",", "b_"}], "]"}], ":=", 
   FractionBox[
    RowBox[{"1", "+", 
     SuperscriptBox["a", "2"]}], 
    RowBox[{
     SqrtBox[
      RowBox[{
       RowBox[{
        SuperscriptBox["c", "2"], "*", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          SuperscriptBox["a", "2"]}], ")"}]}], "-", 
       SuperscriptBox["b", "2"]}]], "+", 
     RowBox[{"a", "*", "b"}]}]]}]}]], "Input",
 CellChangeTimes->{{3.458336433609327*^9, 3.458336544572354*^9}, 
   3.458336624779181*^9, {3.458337904332962*^9, 3.458337930459144*^9}, {
   3.458346109702055*^9, 3.458346130786083*^9}, {3.459120726677939*^9, 
   3.459120738230687*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"v", "[", "x_", "]"}], ":=", 
   RowBox[{"5", "*", 
    RowBox[{"Sin", "[", 
     RowBox[{
      FractionBox["\[Pi]", "5"], "*", "x"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"c", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"s", "=", 
   RowBox[{"NDSolve", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"D", "[", 
         RowBox[{
          RowBox[{"D", "[", 
           RowBox[{
            RowBox[{"L", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"y", "'"}], "[", "x", "]"}], ",", 
              RowBox[{"v", "[", "x", "]"}]}], "]"}], ",", 
            RowBox[{
             RowBox[{"y", "'"}], "[", "x", "]"}]}], "]"}], ",", "x"}], "]"}], 
        "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"y", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"y", "'"}], "[", "5", "]"}], "\[Equal]", "0"}]}], "}"}], ",",
      "y", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "5"}], "}"}]}], "]"}]}], ";", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"Evaluate", "[", 
      RowBox[{
       RowBox[{"y", "[", "x", "]"}], "/.", "s"}], "]"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "5"}], "}"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"y", "[", "x", "]"}]}], "}"}]}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.458337145718498*^9, 3.458337273247143*^9}, {
  3.458337311422447*^9, 3.458337324661732*^9}, {3.458337489665251*^9, 
  3.458337494699066*^9}, {3.458337538860741*^9, 3.458337595593915*^9}, {
  3.458337694142674*^9, 3.458337696571073*^9}, {3.458338006490382*^9, 
  3.458338045783705*^9}, {3.458338091231752*^9, 3.458338092648457*^9}, {
  3.458338348891777*^9, 3.458338403487811*^9}, {3.458338435539371*^9, 
  3.458338532709144*^9}, {3.458338571297606*^9, 3.458338582851764*^9}, {
  3.45833873148123*^9, 3.458338780408835*^9}, {3.458339367261226*^9, 
  3.458339367494754*^9}, {3.458339434654826*^9, 3.458339434806667*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], Thickness[Large], LineBox[CompressedData["
1:eJwV03c4198XAHArZSTe75IWGkbIO9+iiM6JNCQlJIpK8kHITFYDDYXsZGQX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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["x", TraditionalForm], 
    FormBox[
     RowBox[{"y", "(", "x", ")"}], TraditionalForm]},
  AxesOrigin->{0, 0},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.458338748551539*^9, 3.45833878570465*^9}, 
   3.458339098660904*^9, 3.458339405319947*^9, 3.458339439920783*^9, {
   3.458346122509623*^9, 3.458346138933517*^9}, 3.459120720031919*^9}]
}, Open  ]]
},
WindowSize->{1280, 718},
WindowMargins->{{0, Automatic}, {26, Automatic}},
FrontEndVersion->"7.0 for Linux x86 (32-bit) (November 10, 2008)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 826, 24, 116, "Input"],
Cell[CellGroupData[{
Cell[1396, 48, 2266, 60, 119, "Input"],
Cell[3665, 110, 5557, 97, 254, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
