function[]=Pulsos(filename,ini,pts)
%
% PROGRAMA PARA CARGAR ARCHIVO ASCII DE DATOS Y 
% CALCULAR EL PROMEDIO EN UN INTERVALO ESPECIFICADO
%
% Ejemplo en consola: 
%
% >> Pulsos('misdatos.txt',122,57)
%
% Lee datos de misdatos.txt y promedia 57 valores, 
% comenzando desde el dato 122. 
% Se imprimen los resultados y construye grafico.
% El grafico destaca en rojo los valores considerados
% en el calculo de la media. 
%
A=-4.9; B=12.25;  %RANGO +/-10 N
%A=-24.5; B=61.25; %RANGO +/-50 N
fprintf('\n    CONVERSION F=AU+B: \n               A=%0.3f N/V\n               B=%0.3f N (modifique en Tirones.m si es necesario)\n',A,B)
%
copyfile(filename,'dummyfile.txt')
load 'dummyfile.txt';
x=dummyfile(:,1);
y=A*dummyfile(:,2)+B;
fin=length(x);
%
x1=x(1:ini-1);
x2=x(ini:ini+pts-1);
x3=x(ini+pts:fin);
y1=y(1:ini-1);          % Background
y2=y(ini:ini+pts-1);    % Peak
y3=y(ini+pts:fin);      % Bacground
fondo=mean(y1);
prome=mean(y2);
fuerz=abs(prome-fondo);
durac=x(ini+pts-1)-x(ini-1);
fprintf('\n      Duracion: %0.3f s\n    Fondo (To): %0.3f N\n    Media (Tm): %0.3f N\n',durac,fondo,prome);
fprintf('         Tm-To: %0.3f N\n\n',fuerz);
plot(x1,y1,'-b*',x2,y2,'r-*',x3,y3,'-b*',x2,prome,'ko','MarkerFaceColor','g')
xlabel('Tiempo [s]');
ylabel('Fuerza [ N ]');
title('Fuerza media de garbanzos sobre la placa')
%
% FIN DEL PROGRAMA
%