function[]=Media(filename,ini,pts)
%
% PROGRAMA PARA CARGAR ARCHIVO ASCII DE DATOS Y 
% CALCULAR EL PROMEDIO EN UN INTERVALO ESPECIFICADO
%
% Ejemplo en consola: 
%
% >> Media('misdatos.txt',122,57)
%
% Lee datos de misdatos.txt y promedia 57 valores, 
% comenzando desde el dato 122. 
% Se imprimen los resultados y construye grafico.
% El grafico destaca en rojo los valores considerados
% en el calculo de la media.
%
escala=1.0;
fprintf('\n    FACTOR DE CONVERSION : %0.3f N/V (modifique en Media.m si es necesario)\n',escala)
%
copyfile(filename,'dummyfile.txt')
load 'dummyfile.txt';
x=dummyfile(:,1);y=escala*dummyfile(:,2);
fin=length(x);
%
x1=x(1:ini-1);
x2=x(ini:ini+pts-1);
x3=x(ini+pts:fin);
y1=y(1:ini-1);          % Background
y2=y(ini:ini+pts-1);    % Peak
y3=y(ini+pts:fin);      % Bacground
fondo=sum(y1)/length(y1);
prome=sum(y2)/length(y2);
fuerz=abs(prome-fondo);
durac=x(ini+pts-1)-x(ini-1);
fprintf('\n    Durac: %0.3f s\n    Fondo: %0.3f N\n    Media: %0.3f N\n',durac,fondo,prome);
fprintf(' FzaMedia: %0.3f N\n\n',fuerz);
plot(x1,y1,'-b*',x2,y2,'r-*',x3,y3,'-b*',x2,prome,'k+','MarkerFaceColor','g')
xlabel('Tiempo [s]');
ylabel('Fuerza Media [ N ]');
title('Fuerza media de garbanzos sobre la placa')
%
% FIN DEL PROGRAMA
%