% -----------------------------------------------------
%  (c) 2000-2004 Theodor Storm <theodor@tstorm.se>
%  http://www.tstorm.se
% -----------------------------------------------------
function fig = kiks_gui()
global KIKS_GUI_COLOR

load kiks_gui

yadd=24;

h0 = figure('CloseRequestFcn','kiks_quit', ...
    'DoubleBuffer','on', ...
    'Color',[0 0 0], ...
    'Colormap',mat0, ...
    'FileName','C:\sandbox\kiks\system\kiks_gui.m', ...
    'Name','KiKS', ...
    'NumberTitle','off', ...
    'PaperPosition',[18 180 616 452], ...
    'PaperUnits','points', ...
    'Position',[4 210 147 673+yadd], ...
    'RendererMode','manual', ...
    'Menu','none', ...
    'KeypressFcn','kiks_matlab_focus', ...
    'ResizeFcn','kiks_gui_resize', ...
    'Tag','KiKS', ...
    'ToolBar','none', ...
    'Visible','off', ...
    'WindowButtonDownFcn','kiks_mouse_moveobj down', ...
    'WindowButtonUpFcn','kiks_mouse_moveobj up');

h1 = uicontrol('Parent',h0, ...
    'BackgroundColor',KIKS_GUI_COLOR, ...
    'ListboxTop',0, ...
    'Position',[3 92 143 356], ...
    'Style','frame', ...
    'Tag','Frame1');
h1 = uicontrol('Parent',h0, ...
    'BackgroundColor',KIKS_GUI_COLOR, ...
    'ListboxTop',0, ...
    'Position',[3 448 143 94], ...
    'Style','frame', ...
    'Tag','kiksnet_frame');
h1 = uicontrol('Parent',h0, ...
    'BackgroundColor',KIKS_GUI_COLOR, ...
    'Callback','kiks_gui_vis2dtoggle', ...
    'ListboxTop',0, ...
    'Position',[4 92 142 20], ...
    'String','enable visualization', ...
    'Tag','toggle2dvis');
h1 = uicontrol('Parent',h0, ...
    'BackgroundColor',KIKS_GUI_COLOR, ...
    'FontName','verdana', ...
    'FontWeight','bold', ...
    'ListboxTop',0, ...
    'Position',[5 431 140 13], ...
    'String','simulation', ...
    'Style','text', ...
    'Tag','StaticText1');
h1 = uicontrol('Parent',h0, ...
    'BackgroundColor',KIKS_GUI_COLOR, ...
    'ListboxTop',0, ...
    'Position',[5 163 140 13], ...
    'String','interpolation limit', ...
    'Style','text', ...
    'Tag','text_interpolation_limit');
h1 = uicontrol('Parent',h0, ...
    'BackgroundColor',[1 1 1], ...
    'Callback','kiks_gui_getlimitlistbox', ...
    'ListboxTop',0, ...
    'Position',[5 143 140 20], ...
    'String',mat1, ...
    'Style','popupmenu', ...
    'Tag','limit_popup', ...
    'Value',4);
h1 = uicontrol('Parent',h0, ...
    'BackgroundColor',[1 1 1], ...
    'Callback','kiks_gui_gettimescale', ...
    'ListboxTop',0, ...
    'Position',[5 283 140 20], ...
    'String',mat2, ...
    'Style','popupmenu', ...
    'Tag','timescale_popup', ...
    'Value',2);
h1 = uicontrol('Parent',h0, ...
    'BackgroundColor',[1 1 1], ...
    'Callback','kiks_gui_getstatlistbox', ...
    'ListboxTop',0, ...
    'Position',[5 182 140 20], ...
    'String',mat3, ...
    'Style','popupmenu', ...
    'Tag','stat_popup', ...
    'Value',4);
h1 = uicontrol('Parent',h0, ...
    'BackgroundColor',KIKS_GUI_COLOR, ...
    'ListboxTop',0, ...
    'Position',[5 202 140 13], ...
    'String','movement limit', ...
    'Style','text', ...
    'Tag','text_movement_limit');
h1 = uicontrol('Parent',h0, ...
    'BackgroundColor',KIKS_GUI_COLOR, ...
    'ListboxTop',0, ...
    'Position',[3 598 143 75], ...
    'Style','frame', ...
    'Tag','arena_frame');
h1 = uicontrol('Parent',h0, ...
    'BackgroundColor',KIKS_GUI_COLOR, ...
    'FontName','verdana', ...
    'FontWeight','bold', ...
    'ListboxTop',0, ...
    'Position',[6 660 138 11], ...
    'String','arena', ...
    'Style','text', ...
    'Tag','StaticText_arena');
h1 = uicontrol('Parent',h0, ...
    'BackgroundColor',KIKS_GUI_COLOR, ...
    'Callback','kiks_arena_window_clear', ...
    'Enable','off', ...
    'ListboxTop',0, ...
    'Position',[75 112 71 20], ...
    'String','redraw', ...
    'Tag','arena_redraw');
h1 = uicontrol('Parent',h0, ...
    'BackgroundColor',KIKS_GUI_COLOR, ...
    'ListboxTop',0, ...
    'Position',[5 344 140 13], ...
    'String','simulated robot', ...
    'Style','text', ...
    'Tag','StaticText99');
h1 = uicontrol('Parent',h0, ...
    'BackgroundColor',[1 1 1], ...
    'Callback','kiks_gui_simulaterobot', ...
    'ListboxTop',0, ...
    'Position',[5 324 140 20], ...
    'String',{' '}, ...
    'Style','popupmenu', ...
    'Tag','simulate_popup', ...
    'Value',1);
h1 = uicontrol('Parent',h0, ...
    'BackgroundColor',KIKS_GUI_COLOR, ...
    'ListboxTop',0, ...
    'Position',[5 303 140 13], ...
    'String','time mode', ...
    'Style','text', ...
    'Tag','text_time_mode');
h1 = uicontrol('Parent',h0, ...
    'BackgroundColor',KIKS_GUI_COLOR, ...
    'Callback','kiks_arena_new;', ...
    'ListboxTop',0, ...
    'Position',[4 638 71 20], ...
    'String','new', ...
    'Tag','arena_new');
h1 = uicontrol('Parent',h0, ...
    'BackgroundColor',KIKS_GUI_COLOR, ...
    'Callback','kiks_arena_edit;', ...
    'ListboxTop',0, ...
    'Position',[75 638 71 20], ...
    'String','edit', ...
    'Tag','arena_edit');
h1 = uicontrol('Parent',h0, ...
    'BackgroundColor',KIKS_GUI_COLOR, ...
    'Callback','kiks_arena_edit_mode;', ...
    'ListboxTop',0, ...
    'Position',[4 618 142 20], ...
    'String','mode: draw', ...
    'Tag','arena_edit_mode', ...
    'visible','off');
h1 = uicontrol('Parent',h0, ...
    'BackgroundColor',KIKS_GUI_COLOR, ...
    'Callback','kiks_load;', ...
    'ListboxTop',0, ...
    'Position',[4 618 71 20], ...
    'String','load', ...
    'Tag','arena_load');
h1 = uicontrol('Parent',h0, ...
    'BackgroundColor',KIKS_GUI_COLOR, ...
    'Callback','kiks_save;', ...
    'ListboxTop',0, ...
    'Position',[75 618 71 20], ...
    'String','save', ...
    'Tag','arena_save');
h1 = uicontrol('Parent',h0, ...
    'BackgroundColor',KIKS_GUI_COLOR, ...
    'Callback','kiks_reset;', ...
    'ListboxTop',0, ...
    'Position',[4 598 71 20], ...
    'String','reset', ...
    'Tag','arena_reset');
h1 = uicontrol('Parent',h0, ...
    'BackgroundColor',KIKS_GUI_COLOR, ...
    'Callback','kiks_checkpoint;', ...
    'ListboxTop',0, ...
    'Position',[75 598 71 20], ...
    'String','checkpoint', ...
    'Tag','arena_checkpoint');
h1 = uicontrol('Parent',h0, ...
    'BackgroundColor',[1 1 1], ...
    'Callback','v=get(gco,''Value''); set(gco,''BackgroundColor'',[v/255 v/255 v/255])', ...
    'Enable','on', ...
    'ListboxTop',0, ...
    'Max',255, ...
    'Min',1, ...
    'Position',[4 598 142 20], ...
    'Style','slider', ...
    'Tag','arena_color_slider', ...
    'Value',255, ...
    'Visible','off');
h1 = uicontrol('Parent',h0, ...
    'BackgroundColor',KIKS_GUI_COLOR, ...
    'ListboxTop',0, ...
    'Position',[3 543 143 55], ...
    'Style','frame', ...
    'Tag','Frame1');
h1 = uicontrol('Parent',h0, ...
    'BackgroundColor',KIKS_GUI_COLOR, ...
    'FontName','verdana', ...
    'FontWeight','bold', ...
    'ListboxTop',0, ...
    'Position',[5 583 140 14], ...
    'String','objects', ...
    'Style','text', ...
    'Tag','StaticText2');
h1 = uicontrol('Parent',h0, ...
    'BackgroundColor',KIKS_GUI_COLOR, ...
    'Callback','kiks_spawn_object', ...
    'ListboxTop',0, ...
    'Position',[75 562 71 20], ...
    'String','add', ...
    'Tag','addobj');
h1 = uicontrol('Parent',h0, ...
    'BackgroundColor',KIKS_GUI_COLOR, ...
    'Callback','kiks_delete_object(10,1)', ...
    'Enable','off', ...
    'ListboxTop',0, ...
    'Position',[4 542 142 20], ...
    'String','delete selected', ...
    'Tag','deleteobj');
h1 = uicontrol('Parent',h0, ...
    'BackgroundColor',[1 1 1], ...
    'ListboxTop',0, ...
    'Position',[4 562 71 20], ...
    'String',mat4, ...
    'Style','popupmenu', ...
    'Tag','objpopup', ...
    'Value',1);
h1 = uicontrol('Parent',h0, ...
    'BackgroundColor',KIKS_GUI_COLOR, ...
    'Callback','kiks_stepsim', ...
    'Enable','off', ...
    'ListboxTop',0, ...
    'Position',[111 410 35 20], ...
    'String','| | >', ...
    'Tag','stepsim');
h1 = uicontrol('Parent',h0, ...
    'BackgroundColor',KIKS_GUI_COLOR, ...
    'Callback','kiks_arena_window_grid', ...
    'Enable','off', ...
    'ListboxTop',0, ...
    'Position',[4 112 71 20], ...
    'String','grid', ...
    'Tag','arena_grid');
%h1 = uicontrol('Parent',h0, ...
%    'BackgroundColor',KIKS_GUI_COLOR, ...
%    'Callback','kiks_gui_ixprox', ...
%    'Enable','off', ...
%    'HorizontalAlignment','left', ...
%    'ListboxTop',0, ...
%    'Position',[6 120 15 15], ...
%    'Style','checkbox', ...
%    'Tag','indexprox_chk', ...
%    'Value',1);
h1 = uicontrol('Parent',h0, ...
    'BackgroundColor',[1 1 1], ...
    'Callback','kiks_gui_getcomplistbox', ...
    'ListboxTop',0, ...
    'Position',[5 220 140 20], ...
    'String',mat5, ...
    'Style','popupmenu', ...
    'Tag','compspeed_popup', ...
    'Value',7);
h1 = uicontrol('Parent',h0, ...
    'BackgroundColor',KIKS_GUI_COLOR, ...
    'FontSize',14, ...
    'ListboxTop',0, ...
    'Position',[4 400 71 30], ...
    'String','00:00', ...
    'Style','text', ...
    'Tag','time');
h1 = uicontrol('Parent',h0, ...
    'BackgroundColor',KIKS_GUI_COLOR, ...
    'FontSize',8, ...
    'ListboxTop',0, ...
    'Position',[4 376 71 30], ...
    'String','100% (100%)', ...
    'Style','text', ...
    'Tag','speedup');
h1 = uicontrol('Parent',h0, ...
    'BackgroundColor',[0 0 0], ...
    'FontWeight','light', ...
    'ForegroundColor',[0.7 0.75 0.75], ...
    'HorizontalAlignment','right', ...
    'ListboxTop',0, ...
    'Position',[113 41 31 13], ...
    'String',' ', ...
    'Style','text', ...
    'Tag','version');
h1 = uicontrol('Parent',h0, ...
    'BackgroundColor',[0 0 0], ...
    'FontWeight','light', ...
    'ForegroundColor',[0.7 0.75 0.75], ...
    'HorizontalAlignment','left', ...
    'ListboxTop',0, ...
    'Position',[4 41 100 13], ...
    'String',' ', ...
    'Style','text', ...
    'Tag','reginfo');
%h1 = uicontrol('Parent',h0, ...
%    'Units','points', ...
%    'BackgroundColor',KIKS_GUI_COLOR, ...
%    'HorizontalAlignment','left', ...
%    'ListboxTop',0, ...
%    'Units','pixels', ...
%    'Position',[25 120 80.25 16], ...
%    'String','fast proximity sensors', ...
%    'Style','text', ...
%    'Tag','StaticText6');
h1 = uicontrol('Parent',h0, ...
    'BackgroundColor',KIKS_GUI_COLOR, ...
    'Callback','kiks_pausesim', ...
    'Enable','off', ...
    'ListboxTop',0, ...
    'Position',[75 410 36 20], ...
    'String','| |', ...
    'Tag','pausesim');
h1 = uicontrol('Parent',h0, ...
    'BackgroundColor',KIKS_GUI_COLOR, ...
    'Callback','kiks_halt', ...
    'Enable','off', ...
    'ListboxTop',0, ...
    'Position',[75 390 71 20], ...
    'String','halt', ...
    'Tag','haltsim');
h1 = uicontrol('Parent',h0, ...
    'BackgroundColor',[0.266666666666667 0.298039215686275 0.368627450980392], ...
    'Callback','kiks_tou;', ...
    'ForegroundColor',[0.7 0.75 0.75], ...
    'ListboxTop',0, ...
    'Position',[4 73 142 16], ...
    'String','Terms of Use', ...
    'Tag','webbtn');
h1 = uicontrol('Parent',h0, ...
    'BackgroundColor',[0.266666666666667 0.298039215686275 0.368627450980392], ...
    'Callback','web www.tstorm.se ;', ...
    'ForegroundColor',[0.7 0.75 0.75], ...
    'ListboxTop',0, ...
    'Position',[4 55 142 16], ...
    'String','http://www.tstorm.se', ...
    'Tag','webbtn');
h1 = uicontrol('Parent',h0, ...
    'BackgroundColor',[0.368627450980392 0.298039215686275 0.266666666666667], ...
    'Callback','kiks_reginfo;', ...
    'ForegroundColor',[0.7 0.75 0.75], ...
    'ListboxTop',0, ...
    'Position',[4 23 142 16], ...
    'String','license data', ...
    'Tag','licbtn');
h1 = uicontrol('Parent',h0, ...
    'BackgroundColor',[1 1 1], ...
    'HorizontalAlignment','left', ...
    'ListboxTop',0, ...
    'Position',[48 488 96 18], ...
    'String','localhost', ...
    'Style','edit', ...
    'Tag','kiksnet_edit', ...
    'TooltipString','enter IP:port of the KiKSnet server you want to connect to.');
h1 = uicontrol('Parent',h0, ...
    'BackgroundColor',KIKS_GUI_COLOR, ...
    'Callback','kiks_server_connect;', ...
    'ListboxTop',0, ...
    'Position',[4 468 142 20], ...
    'String','connect to KiKSnet server', ...
    'Tag','kiksnet_btn');
h1 = uicontrol('Parent',h0, ...
    'BackgroundColor',KIKS_GUI_COLOR, ...
    'Callback','kiks_kiksnet;', ...
    'ListboxTop',0, ...
    'Position',[4 448 142 20], ...
    'String','administrate KiKSnet server', ...
    'Tag','kiksnet_server_btn');
h1 = uicontrol('Parent',h0, ...
    'BackgroundColor',KIKS_GUI_COLOR, ...
    'FontName','verdana', ...
    'FontWeight','bold', ...
    'ListboxTop',0, ...
    'Position',[5 528 140 13], ...
    'String','KiKSnet', ...
    'Style','text', ...
    'Tag','kiksnet_text');
h1 = uicontrol('Parent',h0, ...
    'BackgroundColor',KIKS_GUI_COLOR, ...
    'HorizontalAlignment','right', ...
    'ListboxTop',0, ...
    'Position',[4 489 45 15], ...
    'String','server : ', ...
    'Style','text', ...
    'Tag','StaticText4');
h1 = uicontrol('Parent',h0, ...
    'BackgroundColor',KIKS_GUI_COLOR, ...
    'HorizontalAlignment','left', ...
    'ListboxTop',0, ...
    'Position',[11 510 70 15], ...
    'String','radio turret id : ', ...
    'Style','text', ...
    'Tag','StaticText4');
h1 = uicontrol('Parent',h0, ...
    'BackgroundColor',[1 1 1], ...
    'Callback','kiks_gui_getaccmethod;', ...
    'ListboxTop',0, ...
    'Position',[5 242 140 20], ...
    'String',mat6, ...
    'Style','popupmenu', ...
    'Tag','acceleration_method', ...
    'Value',1);
h1 = uicontrol('Parent',h0, ...
    'BackgroundColor',KIKS_GUI_COLOR, ...
    'ListboxTop',0, ...
    'Position',[5 262 140 13], ...
    'String','time acceleration method', ...
    'Style','text', ...
    'Tag','text_time_acceleration_method');
h1 = uicontrol('Parent',h0, ...
    'BackgroundColor',[1 1 1], ...
    'Callback','kiks_gui_gettargetspeed;', ...
    'Enable','off', ...
    'ListboxTop',0, ...
    'Max',2000, ...
    'Min',100, ...
    'Position',[6 219 138 20], ...
    'Style','slider', ...
    'Tag','speed_target', ...
    'Value',100, ...
    'Visible','off');
h1 = uicontrol('Parent',h0, ...
    'BackgroundColor',KIKS_GUI_COLOR, ...
    'Callback','kiks_gui_monitorbtn', ...
    'ListboxTop',0, ...
    'Position',[4 370 142 20], ...
    'String','monitor simulation details', ...
    'Tag','monitor');
h1 = uicontrol('Parent',h0, ...
    'BackgroundColor',KIKS_GUI_COLOR, ...
    'FontWeight','bold', ...
    'HorizontalAlignment','left', ...
    'ListboxTop',0, ...
    'Position',[80 510 50 15], ...
    'String','n/a', ...
    'Style','text', ...
    'Tag','radioid');
h1 = axes('Parent',h0, ...
    'Units','pixels', ...
    'Box','on', ...
    'CameraUpVector',[0 1 0], ...
    'CameraUpVectorMode','manual', ...
    'Color',[1 1 1], ...
    'ColorOrder',mat7, ...
    'Layer','top', ...
    'NextPlot','add', ...
    'Position',[148 124.438202247191 450 326.123595505618], ...
    'Tag','arena_axes', ...
    'Visible','off', ...
    'XColor',[0 0 0], ...
    'XLim',[0 178], ...
    'XLimMode','manual', ...
    'YColor',[0 0 0], ...
    'YDir','reverse', ...
    'YLim',[0 129], ...
    'YLimMode','manual', ...
    'ZColor',[0 0 0]);
h2 = text('Parent',h1, ...
    'Color',[0 0 0], ...
    'HandleVisibility','off', ...
    'HorizontalAlignment','center', ...
    'Position',[89.19821826280622 -2.769938650306756 9.160254037844386], ...
    'Tag','arena_axesText4', ...
    'VerticalAlignment','cap', ...
    'Visible','off');
set(get(h2,'Parent'),'XLabel',h2);
h2 = text('Parent',h1, ...
    'Color',[0 0 0], ...
    'HandleVisibility','off', ...
    'HorizontalAlignment','center', ...
    'Position',[180.7750556792873 64.10429447852761 9.160254037844386], ...
    'Rotation',90, ...
    'Tag','arena_axesText3', ...
    'VerticalAlignment','baseline', ...
    'Visible','off');
set(get(h2,'Parent'),'YLabel',h2);
h2 = text('Parent',h1, ...
    'Color',[0 0 0], ...
    'HandleVisibility','off', ...
    'Position',[236.6726057906459 169.361963190184 9.160254037844386], ...
    'Tag','arena_axesText2', ...
    'Visible','off');
set(get(h2,'Parent'),'ZLabel',h2);
h2 = text('Parent',h1, ...
    'Color',[0 0 0], ...
    'HandleVisibility','off', ...
    'HorizontalAlignment','center', ...
    'Position',mat8, ...
    'Tag','arena_axesText1', ...
    'VerticalAlignment','bottom', ...
    'Visible','off');
set(get(h2,'Parent'),'Title',h2);
h1 = uicontrol('Parent',h0, ...
    'Units','pixels', ...
    'Position',[0 0 500 23], ...
    'Style','frame', ...
    'Tag','status_dummy');
h1 = uicontrol('Parent',h0, ...
    'Units','pixels', ...
    'FontName','Courier New', ...
    'FontSize',8, ...
    'HorizontalAlignment','left', ...
    'Position',[148 5 250 12], ...
    'Style','text', ...
    'String','',...
    'Tag','status');
h1 = uicontrol('Parent',h0, ...
    'Callback','kiks_gui_loghistory', ...
    'ListboxTop',0, ...
    'Position',[4 1 142 18], ...
    'String','view log history', ...
    'Tag','togglelog');
h1 = uicontrol('Parent',h0, ...
    'BackgroundColor',[1 1 1], ...
    'HorizontalAlignment','left', ...
    'ListboxTop',0, ...
    'Units','pixels', ...
    'Position',[76 -20 70 20], ...
    'FontName','Courier New', ...
    'FontSize',9, ...
    'String','', ...
    'Style','edit', ...
    'Tag','kiks_matlab_command', ...
    'Callback','g=findobj(gcf,''tag'',''toggle_foreground''); set(g,''enable'',''off''); h=findobj(gcf,''tag'',''kiks_matlab_command''); command=get(h,''String''); kiks_status([''>> '' command]); disp([''>> '' command]); set(h,''String'',[''executing evalc('''''' command '''''')...'']); try, res=evalc(command); catch, res=[''??? '' lasterr]; end; set(h,''String'',''''); kiks_status(res); disp(res); g=findobj(gcf,''tag'',''toggle_foreground''); set(g,''enable'',''on'');', ...
    'TooltipString','Enter Matlab command to execute');
h1 = uicontrol('Parent',h0, ...
    'Callback','kiks_foreground', ...
    'ListboxTop',0, ...
    'Position',[4 -21 71 20], ...
    'String','go active', ...
    'Tag','toggle_foreground');

% KiKSnet stuff
h1 = uicontrol('Parent',h0, ...
    'BackgroundColor',KIKS_GUI_COLOR, ...
    'ListboxTop',0, ...
    'Position',[5 242 140 17], ...
    'String','', ...
    'Style','text', ...
    'Tag','t_kiksnet_text_server',...
    'FontWeight','bold', ...
    'Visible','off');
h1 = uicontrol('Parent',h0, ...
    'BackgroundColor',KIKS_GUI_COLOR, ...
    'FontSize',14, ...
    'ListboxTop',0, ...
    'Position',[4 171 140 30], ...
    'String','?', ...
    'Style','text', ...
    'Tag','t_kiksnet_text_ping',...
    'Visible','off');
h1 = uicontrol('Parent',h0, ...
    'BackgroundColor',KIKS_GUI_COLOR, ...
    'Callback','kiks_gui_placerobot', ...
    'ListboxTop',0, ...
    'Position',[4 303 142 20], ...
    'String','place robot', ...
    'Visible','off', ...
    'Tag','t_kiksnet_place_robot');

% KiKSnet server stuff
h1 = uicontrol('Parent',h0, ...
    'BackgroundColor',[1 1 1], ...
    'ListboxTop',0, ...
    'Position',[7 480 135 42], ...
    'Style','frame', ...
    'Visible','off', ...
    'Tag','t_kiksnetserver_frame1');
h1 = uicontrol('Parent',h0, ...
    'BackgroundColor',[1 1 1], ...
    'ListboxTop',0, ...
    'Position',[10 500 35 17], ...
    'String','server:', ...
    'Style','text', ...
    'Tag','t_kiksnetserver_text_server_text',...
    'FontWeight','normal', ...
    'HorizontalAlignment','left', ...
    'Visible','off');
h1 = uicontrol('Parent',h0, ...
    'BackgroundColor',[1 1 1], ...
    'ListboxTop',0, ...
    'Position',[45 500 90 17], ...
    'String','?', ...
    'Style','text', ...
    'Tag','t_kiksnetserver_text_server',...
    'HorizontalAlignment','right', ...
    'FontWeight','bold', ...
    'Visible','off');

h1 = uicontrol('Parent',h0, ...
    'BackgroundColor',[1 1 1], ...
    'ListboxTop',0, ...
    'Position',[10 485 35 17], ...
    'String','clients:', ...
    'Style','text', ...
    'Tag','t_kiksnetserver_text_clients_text',...
    'FontWeight','normal', ...
    'HorizontalAlignment','left', ...
    'Visible','off');
h1 = uicontrol('Parent',h0, ...
    'BackgroundColor',[1 1 1], ...
    'ListboxTop',0, ...
    'Position',[45 485 90 17], ...
    'String','?', ...
    'Style','text', ...
    'Tag','t_kiksnetserver_text_clients',...
    'HorizontalAlignment','right', ...
    'FontWeight','bold', ...
    'Visible','off');

for i=0:3
    spacing=70;
    h1 = uicontrol('Parent',h0, ...
        'BackgroundColor',KIKS_GUI_COLOR, ...
        'ListboxTop',0, ...
        'Position',[7 323-i*spacing 135 spacing+1], ...
        'Style','frame', ...
        'Visible','off', ...
        'Tag',sprintf('t_kiksnetserver_clientstats_%d_frame',i+1));
    h1 = uicontrol('Parent',h0, ...
        'BackgroundColor',[0.3 0.3 0.3], ...
        'ForegroundColor',[1 1 1], ...
        'ListboxTop',0, ...
        'Position',[8 379-i*spacing 133 14], ...
        'Style','text', ...
        'String','', ...
        'HorizontalAlignment','center', ...
        'FontWeight','bold', ...
        'Visible','off', ...
        'Tag',sprintf('t_kiksnetserver_clientstats_%d_callsign',i+1));
    h1 = uicontrol('Parent',h0, ...
        'BackgroundColor',KIKS_GUI_COLOR, ...
        'ListboxTop',0, ...
        'Position',[8 325-i*spacing 49 53], ...
        'Style','text', ...
        'String',{'Radio ID:','License:','IP:','Score:'}, ...
        'HorizontalAlignment','right', ...
        'Visible','off', ...
        'Tag',sprintf('t_kiksnetserver_clientstats_%d_text',i+1));
    h1 = uicontrol('Parent',h0, ...
        'BackgroundColor',KIKS_GUI_COLOR, ...
        'ListboxTop',0, ...
        'Position',[59 325-i*spacing 82 53], ...
        'Style','text', ...
        'String','', ...
        'HorizontalAlignment','left', ...
        'Visible','off', ...
        'FontWeight','bold', ...
        'Tag',sprintf('t_kiksnetserver_clientstats_%d',i+1));
end;
h1 = uicontrol('Parent',h0, ...
    'BackgroundColor',KIKS_GUI_COLOR, ...
    'Callback','kiks_gui_kiksnet_scroll(-1);', ...
    'ListboxTop',0, ...
    'Position',[7 411 135 18], ...
    'String','scroll up', ...
    'Visible','off', ...
    'Tag','t_kiksnetserver_scrollup');
h1 = uicontrol('Parent',h0, ...
    'BackgroundColor',KIKS_GUI_COLOR, ...
    'Callback','kiks_gui_kiksnet_scroll(1);', ...
    'ListboxTop',0, ...
    'Position',[7 393 135 18], ...
    'String','scroll down', ...
    'Visible','off', ...
    'Tag','t_kiksnetserver_scrolldown');

h=findobj(h0);
for i=1:length(h)
    p=get(h(i),'Position');
    p(2)=p(2)+yadd;
    set(h(i),'Position',p);
end;
h=findobj(h0,'tag','status_dummy');
p=get(h,'Position');
p(2)=0;
p(4)=p(4)+yadd;
set(h,'Position',p);
set(h0,'Visible','on');

if nargout > 0, fig = h0; end
