% -----------------------------------------------------
%  (c) 2000-2004 Theodor Storm <theodor@tstorm.se>
%  http://www.tstorm.se
% -----------------------------------------------------

function res=kiks_delete_robot(id)
global KIKS_NR_HDL KIKS_COLOR_ROBOT KIKS_MONITOR_ON KIKS_MONITOR_WIN KIKS_LINVIS_GR_HDL KIKS_LINVIS_HDL KIKS_RBTARRAY KIKS_RBTLIST KIKS_GUI_HDL KIKS_2DVISUALIZE KIKS_RBT_HDL KIKS_RBTSENS_HDL KIKS_RBTWHL_HDL KIKS_RBTLMP_HDL KIKS_RBTDIOD_HDL KIKS_ROBOT_MATRIX;

if(nargin<1) id = kiks_gui_getportvalue; end;

[rows,cols]=size(KIKS_RBTARRAY);
if(cols<=0) return; end; 
newarray=[];

h=findobj(KIKS_GUI_HDL,'Tag','kheppopup');
v=get(h,'Value');

j=0;
for i=1:cols,
    j=j+1;
    if(KIKS_RBTARRAY(i)~=id)
        newarray(j)=KIKS_RBTARRAY(i);
    else
        j=j-1;
    end
end;

KIKS_RBTARRAY=newarray;
[rows,cols]=size(KIKS_RBTARRAY);
KIKS_RBTLIST={};
for i=1:cols,
    KIKS_RBTLIST(i)={sprintf('Port %d',-KIKS_RBTARRAY(i))};
end;

empty=0;
if isempty(KIKS_RBTLIST)
    KIKS_RBTLIST={'(empty)'};
    empty=1;
end;

try
    h=findobj(KIKS_GUI_HDL,'Tag','kheppopup');
    set(h,'String',KIKS_RBTLIST);
    if(v>1) set(h,'Value',v-1);
    else set(h,'Value',1); end;
    if empty==1
        set(h,'Enable','off');
        h=findobj(KIKS_GUI_HDL,'Tag','deletekhep');
        set(h,'Enable','off');
        h=findobj(KIKS_GUI_HDL,'Tag','monkhep');
        set(h,'Enable','off');      
    end;
end;

if(KIKS_2DVISUALIZE>0)   
    delete(KIKS_RBT_HDL(abs(id)));
    delete(KIKS_RBTSENS_HDL(abs(id)));
    delete(KIKS_RBTWHL_HDL(abs(id)));
    delete(KIKS_RBTLMP_HDL(abs(id)));
    delete(KIKS_RBTDIOD_HDL(abs(id),1));
    delete(KIKS_RBTDIOD_HDL(abs(id),2));
    delete(KIKS_LINVIS_GR_HDL(abs(id)));
    delete(KIKS_LINVIS_HDL(abs(id)));
    g=findobj('tag',sprintf('%dsens',abs(id)));
    delete(g);
end;

%if KIKS_MONITOR_ON(abs(id))==1
%    delete(KIKS_MONITOR_WIN(abs(id)));
%    KIKS_MONITOR_ON(abs(id))=0;
%end;


xp = floor(KIKS_ROBOT_MATRIX(abs(id),1,1));
yp = floor(KIKS_ROBOT_MATRIX(abs(id),1,2));
%kiks_arena_subrobot(abs(id),xp,yp);
kiks_arena_sub_mask(xp,yp,KIKS_COLOR_ROBOT,KIKS_ROBOT_MATRIX(abs(id),2,2));
