% -----------------------------------------------------
%  (c) 2000-2004 Theodor Storm <theodor@tstorm.se>
%  http://www.tstorm.se
% -----------------------------------------------------

function res=kiks_calculate_gripper(id)
global KIKS_REMOTE_ARRAY_NEW KIKS_FID KIKS_ARENA_MX KIKS_ARENA_MASK KIKS_TIMESCALE KIKS_ROBOT_MATRIX KIKS_PROX_POS KIKS_LIGHT_POS KIKS_SPDC KIKS_SESSIONACTIVE;
global KIKS_RBTMASK KIKS_GUI_HDL KIKS_REMOTE_OBJECTS_ARRAY_NEW KIKS_NET_BUFSIZ;
global KIKS_mappic KIKS_MMPERPIXEL KIKS_WALL_WIDTH KIKS_RBTARRAY KIKS_ROUNDOBJARRAY KIKS_ROUNDOBJDATA KIKS_ROUNDOBJECT_RADIUS;
global KIKS_WALL_RENDER KIKS_GRIPPER_XCOORD KIKS_GRIPPER_YCOORD KIKS_GRIPPER_GRP_XCOORD KIKS_GRIPPER_GRP_YCOORD
global KIKS_GRIPPER_ARM_X KIKS_GRIPPER_ARM_Y KIKS_GRIPPER_LGRP_X KIKS_GRIPPER_LGRP_Y KIKS_GRIPPER_RGRP_X KIKS_GRIPPER_RGRP_Y;

% calculate points for gripper/gripper arm
KIKS_GRIPPER_XCOORD = [-30  30  34  34  30 -30 -29  48  48 -30 -30]/KIKS_MMPERPIXEL;
KIKS_GRIPPER_XCOORD=KIKS_GRIPPER_XCOORD+26;
KIKS_GRIPPER_XCOORD=-KIKS_GRIPPER_XCOORD;
KIKS_GRIPPER_XCOORD=KIKS_GRIPPER_XCOORD*cos((pi/180)*(-10+(KIKS_ROBOT_MATRIX(id,11,1)*(200/255))));
if abs(KIKS_GRIPPER_XCOORD(3)-KIKS_GRIPPER_XCOORD(8))<8 KIKS_GRIPPER_XCOORD(8)=KIKS_GRIPPER_XCOORD(3)+sign(KIKS_GRIPPER_XCOORD(3))*8; KIKS_GRIPPER_XCOORD(9)=KIKS_GRIPPER_XCOORD(4)+sign(KIKS_GRIPPER_XCOORD(4))*8; end;
KIKS_GRIPPER_XCOORD=KIKS_GRIPPER_XCOORD-26;
KIKS_GRIPPER_YCOORD = [ 30  30  25 -25 -30 -30 -36 -36  36  36  30]/KIKS_MMPERPIXEL;
%set(KIKS_GRIPPER_HDL(id),'xdata',kx+(KIKS_GRIPPER_XCOORD*cos(-KIKS_ROBOT_MATRIX(id,1,3))-KIKS_GRIPPER_YCOORD*sin(-KIKS_ROBOT_MATRIX(id,1,3)))-floor(KIKS_WALL_WIDTH_SCALED)+floor(KIKS_WALL_RENDER_SCALED),'ydata',ky+(KIKS_GRIPPER_XCOORD*sin(-KIKS_ROBOT_MATRIX(id,1,3))+KIKS_GRIPPER_YCOORD*cos(-KIKS_ROBOT_MATRIX(id,1,3)))-floor(KIKS_WALL_WIDTH_SCALED)+floor(KIKS_WALL_RENDER_SCALED));
KIKS_GRIPPER_GRP_XCOORD=[0 -37*cos((pi/180)*(-10+(KIKS_ROBOT_MATRIX(id,11,1)*(200/255)))) -37*cos((pi/180)*(-10+(KIKS_ROBOT_MATRIX(id,11,1)*(200/255)))) 0]/KIKS_MMPERPIXEL;
KIKS_GRIPPER_GRP_XCOORD=KIKS_GRIPPER_GRP_XCOORD+KIKS_GRIPPER_XCOORD(8);
pos=0.5+(27/200)*KIKS_ROBOT_MATRIX(id,11,2);
KIKS_GRIPPER_GRP_YCOORD=[pos pos pos+4 pos+4]/KIKS_MMPERPIXEL;

KIKS_WALL_WIDTH_SCALED=KIKS_WALL_WIDTH/KIKS_MMPERPIXEL;
KIKS_WALL_RENDER_SCALED=KIKS_WALL_RENDER/KIKS_MMPERPIXEL;

kx = (KIKS_ROBOT_MATRIX(id,1,1)/KIKS_MMPERPIXEL);
ky = (KIKS_ROBOT_MATRIX(id,1,2)/KIKS_MMPERPIXEL);

KIKS_GRIPPER_ARM_X=kx+(KIKS_GRIPPER_XCOORD*cos(-KIKS_ROBOT_MATRIX(id,1,3))-KIKS_GRIPPER_YCOORD*sin(-KIKS_ROBOT_MATRIX(id,1,3)));
KIKS_GRIPPER_ARM_Y=ky+(KIKS_GRIPPER_XCOORD*sin(-KIKS_ROBOT_MATRIX(id,1,3))+KIKS_GRIPPER_YCOORD*cos(-KIKS_ROBOT_MATRIX(id,1,3)));
KIKS_GRIPPER_LGRP_X=kx+(KIKS_GRIPPER_GRP_XCOORD*cos(-KIKS_ROBOT_MATRIX(id,1,3))-KIKS_GRIPPER_GRP_YCOORD*sin(-KIKS_ROBOT_MATRIX(id,1,3)));
KIKS_GRIPPER_LGRP_Y=ky+(KIKS_GRIPPER_GRP_XCOORD*sin(-KIKS_ROBOT_MATRIX(id,1,3))+KIKS_GRIPPER_GRP_YCOORD*cos(-KIKS_ROBOT_MATRIX(id,1,3)));
KIKS_GRIPPER_RGRP_X=kx+(KIKS_GRIPPER_GRP_XCOORD*cos(-KIKS_ROBOT_MATRIX(id,1,3))-(-KIKS_GRIPPER_GRP_YCOORD)*sin(-KIKS_ROBOT_MATRIX(id,1,3)));
KIKS_GRIPPER_RGRP_Y=ky+(KIKS_GRIPPER_GRP_XCOORD*sin(-KIKS_ROBOT_MATRIX(id,1,3))+(-KIKS_GRIPPER_GRP_YCOORD)*cos(-KIKS_ROBOT_MATRIX(id,1,3)));
