# Define model builder
# --------------------
wipe;
model basic -ndm 2 -ndf 3

# Define materials 
# ----------------

uniaxialMaterial ENT 1 20000.0

# Define cross-section 
# ---------------------

section Fiber 1 {

    patch rect 1 10 4 -1.5 -6.0 1.5 6.0
    patch rect 1 4 10 -6 -1.5 6.0 1.5

}    

# Set axial load 
set P -5000.0

set numIncr 100;	# Number of analysis increments


	# Define two nodes at (0,0)
	node 1 0.0 0.0
	node 2 0.0 0.0

	# Fix all degrees of freedom except axial and bending
	fix 1 1 1 1
	fix 2 0 1 0

	
	# Define element
	#                         tag ndI ndJ  secTag
	element zeroLengthSection  1   1   2  1

	# Create recorder
	recorder Node -file Mphi.out -time -node 2 -dof 1 3 disp; # time=M, disp=e0,fi
	recorder Element -file Force1.out -time -ele 1 force; # time=M, force=P1,V1,M1,P2,V2,M2

	# Define constant axial load
	pattern Plain 1 "Constant" {
		load 2 $P 0.0 0.0
	}

	# Define analysis parameters
	integrator LoadControl 0 1 0 0
	system SparseGeneral -piv;	
	test NormUnbalance 1.0e-9 10
	numberer Plain
	constraints Plain
	algorithm Newton
	analysis Static

	# Do one analysis for constant axial load
	analyze 1

	# Define reference moment

	pattern Plain 2 "Linear" { 
		load 2 0.0 0.0 1.0
	}
	
	integrator LoadControl 200.0 1 200.0 200.0

	# Use displacement control at node 2 for section analysis
	#set dK 0.00002
	#integrator DisplacementControl 2 3 $dK 1 $dK $dK
	
	# Do the section analysis
	analyze $numIncr



