package databasestudents;

import org.junit.Before;
import org.junit.Test;

import java.util.List;

import static org.junit.Assert.*;

public class DatabaseTest {
    private Database d, empty;
    private Student s1, s2, s3;
    private Lecture l1, l2, l3;

    @Before
    public void setUp() {
        empty = new Database();
        d = new Database();

        s1 = new Student("Uwu", "12.344.123-8");
        s2 = new Student("Uwo", "21.344.125-8");
        s3 = new Student("Eva", "22.344.125-8");

        l1 = new Lecture("CC3002", "Methodology");
        l2 = new Lecture("CC4901", "Practica 1");
        l3 = new Lecture("CC5901", "Practica 2");

        d.addStudent(s1);
        d.addStudent(s2);
        d.addStudent(s3);

        d.addLecture(l1);
        d.addLecture(l2);
        d.addLecture(l3);

        s1.addLecture(l1);
        s1.addLecture(l2);
        s3.addLecture(l3);
    }

    @Test
    public void testEmpty() {
        assertTrue(empty.isEmpty());
        assertEquals(0, empty.numberOfStudents());
        assertEquals(0, empty.numberOfLectures());
    }

    @Test
    public void testNotEmpty() {
        assertFalse(d.isEmpty());
        assertEquals(3, d.numberOfStudents());
        assertEquals(3, d.numberOfLectures());

        d.addLecture(new Lecture("CC3001", "Introduction"));
        assertEquals(3, d.numberOfStudents());
        assertEquals(4, d.numberOfLectures());
    }

    @Test
    public void testAllLectureCodes() {
        List<String> allLectureCodes = d.allLectureCodes();
        assertEquals(3, allLectureCodes.size());
        assertTrue(allLectureCodes.contains("CC3002"));
        assertTrue(allLectureCodes.contains("CC4901"));
        assertTrue(allLectureCodes.contains("CC5901"));
    }

    @Test
    public void testAssociations() {
        assertTrue(s1.isPartOf(l1));
        assertTrue(s1.isPartOf(l2));
        assertFalse(s1.isPartOf(l3));

        assertTrue(s3.isPartOf(l3));
        assertFalse(s3.isPartOf(l1));
    }

    @Test(expected = AssertionError.class)
    public void testNoDuplicatedLecture(){
        assertEquals(3, d.numberOfLectures());
        d.addLecture(l1);
    }

    @Test(expected = AssertionError.class)
    public void testNoDuplicatedLecture2(){
        d.addLecture(new Lecture("CC3002", "Methodology"));
    }

    @Test(expected = AssertionError.class)
    public void testStudentNotInTheSameLecture() {
        s1.addLecture(l1);
    }

    @Test
    public void getStudentFromRUT() {
        assertEquals(s1, d.getStudentFromRUT("12.344.123-8"));
    }

    @Test
    public void studentsFromLectures() {
        assertEquals(1, l1.getStudents().size());
        assertTrue(l1.getStudents().contains(s1));

        s2.addLecture(l1);
        assertEquals(2, l1.getStudents().size());
        assertTrue(l1.getStudents().contains(s1));
        assertTrue(l1.getStudents().contains(s2));
    }
}
