package databasestudents;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;

public class Database {
    private List<Student> students;
    private List<Lecture> lectures;

    public Database() {
        students = new ArrayList<>();
        lectures = new ArrayList<>();
    }

    public void addStudent(Student student) {
        students.add(student);
    }

    public void addLecture(Lecture lecture) {
        if(this.allLectureCodes().contains(lecture.getCode()))
            throw new AssertionError("Lecture already added");

        lectures.add(lecture);
    }

    /**
     * Return the list of all the code of the lectures.
     * @return
     */
    public List<String> allLectureCodes() {
        List<String> tmp = new ArrayList<>();
        for(Lecture lecture : lectures)
            if(!tmp.contains(lecture.getCode()))
                tmp.add(lecture.getCode());
        return tmp;
    }

    public boolean isEmpty() {
        return lectures.isEmpty() && students.isEmpty();
    }

    public int numberOfStudents() {
        return students.size();
    }

    public int numberOfLectures() {
        return lectures.size();
    }

    /**
     * Obtain a student from a rut
     * @param rut
     * @return
     */
    public Student getStudentFromRUT(String rut) {
        Hashtable<String,Student> mapping = new Hashtable<>();
        for(Student student : students)
            mapping.put(student.getRut(), student);
        return mapping.get(rut);
    }
}