/*
 * Ineficiente: Esta es una implementacion secuencial.
/* Modifique este programa para que se compilen hasta p archivos
 * en paralelo.
 */

#include "set.h"
#include "srcfile.h"
#include <nSystem.h>

nMonitor readyMonitor;
nMonitor compilingMonitor;
nMonitor numTasksMonitor;
int currentTasks;
int maximumTasks;
Set *compilingList;
Set *readyList;

void seqMakeRec(Set *readyList, SrcFile *file) {
  if (!contains(readyList, file->name)) {
    int i;                                 /* No ha sido compilado aun. */
    for (i= 0; file->deps[i]!=NULL; i++)   /* Primero compilar  */
      seqMakeRec(readyList, file->deps[i]); /* las dependencias. */
    compile(file);                         /* Compilar y agregar a */
    add(readyList, file->name);             /* readyList para que no se   */
  }                                        /* recompile.                */
}

void seqMake(SrcFile *file) { seqMakeRec(makeSet(), file); }

void parMakeTask(SrcFile *file) {
	/* Consultar si el archivo ya esta en compilacion (o ya fue compilado) */
	nEnter(compilingMonitor);
	if(contains(compilingList, file->name)) {
		/* El archivo esta siendo (o ya fue) compilado */
		nExit(compilingMonitor);
		/* Esperar hasta que el archivo este listo */
		nEnter(readyMonitor);
		while(!contains(readyList, file->name)){
			nWait(readyMonitor);
		}
		/* El archivo ya esta compilado, salir */
		nExit(readyMonitor);
		nExitTask(0);
	} else {
		/* El archivo no esta listo ni en compilacion */
		/* Agregando a la lista de compilacion */
		add(compilingList, file->name);
		nExit(compilingMonitor);
		/* Contar el numero de dependencias del archivo */
		int numDepen;
		for(numDepen = 0; file->deps[numDepen] != NULL; ++numDepen);
		/* Crear arreglo de tareas de dependencia */
		nTask dependencyTasks[numDepen];
		/* Emitir una tarea para cada dependencia */
		int i;						
		for(i = 0; i < numDepen; ++i){	
			dependencyTasks[i] = nEmitTask(parMakeTask, file->deps[i]);
      	}
      	/* Esperar a que todas las tareas esten terminadas
		 * No importa que algunas terminen antes que otras y no se detecte
		 * pues solo se puede continuar cuando todas estan listas */
      	for(i=0; i < numDepen; ++i) {
      		nWaitTask(dependencyTasks[i]);
      	}
      	/* Todo listo para empezar a compilar, se espera un puesto libre
		 * en el numero maximo de trabajos concurrentes */
      	nEnter(numTasksMonitor);
        while(currentTasks == maximumTasks){
          	nWait(numTasksMonitor);
        }
        /* Se reserva el puesto libre,
		 * se notifica a los otros threads en espera
		 * y se libera el monitor */
        ++currentTasks;
        nNotifyAll(numTasksMonitor);
      	nExit(numTasksMonitor);
      	/* Puesto reservado, se procede a compilar el archivo */
      	compile(file);
      	/* Termino la compilacion, actualizar el numero
		 * de trabajos actuales, notificar y soltar el monitor */
      	nEnter(numTasksMonitor);
        --currentTasks;
        nNotifyAll(numTasksMonitor);
      	nExit(numTasksMonitor);
      	/* Registrar archivo en la lista de compilados */
      	nEnter(readyMonitor);
        add(readyList, file->name);
        nNotifyAll(readyMonitor);
      	nExit(readyMonitor);
      	/* Archivo compilado y registrado, salir */
      	nExitTask(0);
	}

}

void parMake(SrcFile *file, int p) {
	/* Crear los conjuntos de archivvos listos y en compilacion (o ya compilados) */
	readyList = makeSet();
	compilingList = makeSet();
	/* Crear los monitores para controlar acceso a lista de terminados,
	 * lista de archivos en compilacion (o ya compilados) y acceso
	 * al contador de archivos en compilacion. */
	readyMonitor = nMakeMonitor();
	compilingMonitor = nMakeMonitor();
	numTasksMonitor = nMakeMonitor();
	/* Cargar el numero maximo y actual de trabajos en compilacion */
	maximumTasks = p;
	currentTasks = 0;
	/* Crear y esperar la compilacion del archivo raiz */
	nTask rootTask = nEmitTask(parMakeTask, file);
	nWaitTask(rootTask);
	/* Limpiar restos */
	nDestroyMonitor(readyMonitor);
	nDestroyMonitor(compilingMonitor);
	nDestroyMonitor(numTasksMonitor);
	destroySet(readyList);
	destroySet(compilingList);
}
