/* AUX 3 - CC41B
 * 29 de Agosto de 2008
 * Para compilar: make APP=aux3p2
 */
#include <stdio.h>
#include "nSystem.h"
#include "fifoqueues.h"

#define MILISEGUNDOS_DORMIR 3000

void modoBajoConsumo(){
    nPrintf("** Entrando a modo bajo consumo **\n");
}
void modoUsoNormal(){
    nPrintf("** Volviendo a modo uso normal **\n");
}

void obtenerImpresora();
void devolverImpresora();
void inicializarImpresora();

/* para las pruebas */
int escritor(int num){
    int i;
    for(i=0; i<2; ++i){
        int milis = 500 + (rand() % 4000);
        obtenerImpresora();
        nPrintf("tarea %i inicio escritura\n", num);
        nSleep(milis);
        nPrintf("tarea %i fin escritura\n", num);
        devolverImpresora();
    }
}
nMain(){
    inicializarImpresora();
    nTask t[3];
    int i;
    for(i=0; i<1; ++i){
        t[i] = nEmitTask(escritor, i);
    }
    for(i=0; i<1; ++i){
        nWaitTask(t[i]);
    }
    nSleep(MILISEGUNDOS_DORMIR + 2000);
    for(i=0; i<3; ++i){
        t[i] = nEmitTask(escritor, i);
    }
    for(i=0; i<3; ++i){
        nWaitTask(t[i]);
    }
}

/*** implementacion ***/
#define OBTENER 1
#define DEVOLVER 2
#define OK 3

nTask impresora;

void obtenerImpresora(){
    int msg = OBTENER;
    nSend(impresora, &msg);
}

void devolverImpresora(){
    int msg = DEVOLVER;
    nSend(impresora, &msg);
}

int impresoraServer(){
    nSetTaskName("TASK impresoraServer");
    nTask t;
    int *msg;
    FifoQueue printerQueue = MakeFifoQueue();
    int busy = FALSE;
    int sleep = FALSE;
    for(;;) {
        if(busy == FALSE){
            //recibir mensajes por cierto tiempo
            msg = (int *) nReceive(&t, MILISEGUNDOS_DORMIR);
            if (t == NULL) {
                //se cumplio el tiempo sin recibir mensajes
                modoBajoConsumo();
                sleep = TRUE;
                //recibir indefinidamente
                msg = (int *) nReceive(&t, -1);
            }
        } else {
            msg = (int *) nReceive(&t, -1);
        }
        if(*msg == OBTENER){
            if(busy == TRUE){
                //la impresora esta ocupada, agrego la solicitud a la fila
                PutObj(printerQueue, t);
            } else {
                //despertar la impresora si es que estaba dormida
                if(sleep == TRUE){
                    modoUsoNormal();
                    sleep = FALSE;
                }
                //ocupar la impresora
                busy = TRUE;
                nReply(t, OK);
            }
        } else if(*msg == DEVOLVER){
            //responder a la tarea
            nReply(t, OK);
            //ver si hay otra tarea esperando por la impresora
            if (!EmptyFifoQueue(printerQueue)){
                nTask *t2 = (nTask *) GetObj(printerQueue);
                nReply(t2, OK);
            } else {
                //si no hay otra tarea, la impresora queda disponible
                busy = FALSE;
            }
        }
    }
}

void inicializarImpresora(){
    impresora = nEmitTask(impresoraServer);
}

