;; The first three lines of this file were inserted by DrScheme. They record metadata
;; about the language level of this file in a form that our tools can easily process.
#reader(planet plai/plai:1:3/lang/reader)
;; The first three lines of this file were inserted by DrScheme. They record metadata
;; about the language level of this file in a form that our tools can easily process.

;(let ((x x)) x)
; Se produce un error de variable no definida {\tt x}, 
; dado que {\tt x} no se definio anteriormente al {\tt let}.

;(letrec ((x x)) x)
;El resultado es un valor no definido. Esto sucede por que el intérprete al evaluar {\tt (x x)} liga
;{\tt x} con un valor {\tt no definido} (1729 en el RCFAE, posteriormente
;este valor cambiará cuando se mute el ambiente), para luego evaluar la
;expresión {\tt x}, dando como resultado un valor no definido.

;La implementación recursiva por la cola, no necesita
;mas espacio en memoria a cada paso de recursion, ya que el contexto de
;control a un nivel dado no se necesita cuando uno pasa al siguiente.
;Concretamente, si un lenguaje tiene optimización tail-call , esta version
;es equivalente en eficiencia (memoria) a una iteración.



;; my-map :: (a -> b) x list-of-a -> list-of-b
(define (my-map f ls)
  (if (null? ls) ls
      (cons (f (car ls)) (my-map f (cdr ls)))))

(test (my-map (λ (x) (* x x)) '(1 2 3)) '(1 4 9))
;; (1 4 9)


;; Version A
;; my-map-tail :: (a -> b) x list-of-a -> list-of-b
(define (my-map-tail f ls)
  (let inter-map ((rest ls) (acc '()))
    (if (null? rest) (reverse acc)
        (inter-map (cdr rest) (cons (f (car rest)) acc)))))

(test (my-map-tail (λ (x) (* x x)) '(1 2 3)) '(1 4 9))
;; (1 4 9)


;; Version B
;; my-map-tail* :: (a -> b) x list-of-a -> list-of-b
;; Implementaci'on 0,3 pts
(define (my-map-tail* f ls) 
  (if (null? ls) ls 
      (iter-map* '() f ls)))

;; inter-map* :: list-of-b x (a -> b) x list-of-a -> list-of-b
(define (iter-map* curr f ls)
     (if (null? ls) (reverse curr)
         (iter-map* (cons (f (car ls)) curr) f (cdr ls))))

(test (my-map-tail* (λ (x) (* x x)) '(1 2 3)) '(1 4 9))
;; (1 4 9)


;; Definici'on de la gram'atica de lambda-c'alculo
(define-type Expr
  (num (n number?))
  (id  (var symbol?))
  (add (left Expr?) (right Expr?))
  (ifc (condition Expr?) (body-then Expr?) (body-else Expr?))
  (fun (arg symbol?) (body Expr?))
  (app (fx Expr?) (param Expr?)))

;; parse:: sList -> Expr
(define (parse sexp)
  (cond
    [(number? sexp) (num sexp)]
    [(symbol? sexp) (id sexp)]
    [(list? sexp)
     (case (first sexp)
       [(+) (add (parse(second sexp))
                 (parse(third sexp)))]
       [(if) (ifc (parse (second sexp)) (parse (third sexp)) (parse (fourth sexp)))]
       [(lambda) (fun (first (second sexp)) (parse (third sexp)))]
       [else (app (parse (first sexp)) (parse (second sexp)))])]))

;;list->set::List-of(symbol) -> List-of(symbol)
;;Recibe un multiconjunto y devuelve su conjunto
(define (list->set ls)
  (if (empty? ls) '() 
      (cons (first ls) (list->set (remove* (list (first ls)) ls)))))


;; free-vars:: Expr -> list-of(symbol)
;; Devuelve la lista de variables libres (sin repetidos)
(define (free-vars expr) (list->set (free-vars* expr)))

;; free-vars*:: Expr -> list-of(symbol)
;; Devuelve la lista de variables libres (con repetidos)
;; obtener lista de variables libres (con repetidos)
(define (free-vars* expr)
  (type-case Expr expr
             (num (n) empty)
             (id (v) (list v))
             (add (l r) (append (free-vars* l) (free-vars* r)))
             (ifc (c bt be) (append (free-vars* c) (free-vars* bt) (free-vars* be)))
             (app (f a) (append (free-vars* f) (free-vars* a)))
             (fun (a b) (remove* (list a) (free-vars* b)))
             ))

;; Variables libres
(test (free-vars (parse '{+ a b})) '(a b))
;; Variables no libre (ligadas)
(test (free-vars (parse '{lambda {x}
                              {+ x x}})) 
      '())
;; Variables fuera del scope
(test (free-vars (parse '{{lambda {x} {lambda {y} {+ x y}}} 
                          {if x x x}}))
      '(x))
