;; The first three lines of this file were inserted by DrScheme. They record metadata
;; about the language level of this file in a form that our tools can easily process.
#reader(planet plai/plai:1:3/lang/reader)
(define-type FAE
   [num (n number?)]
   [add (l FAE?)
        (r FAE?)]
   [sub (l FAE?)
        (r FAE?)]
  [id (name symbol?)]
  [fun (param symbol?) (body FAE?)]
  [app (fun-expr FAE?) (arg-expr FAE?)]
  [if0 (test-case FAE?) (truth FAE?) (falsity FAE?)]
  )

;; parse : sexp -> FAE
(define (parse sexp)
   (cond
     [(number? sexp) (num sexp)]
     [(list? sexp)
      (case (first sexp)
        [(+) (add (parse(second sexp))
                  (parse(third sexp)))]
        [(-) (sub (parse(second sexp))
                  (parse(third sexp)))]
        [(with) (app (fun (first (second sexp)) (parse (third sexp))) 
                      (parse (second (second sexp)))) ]
        [(fun) (fun (first (second sexp)) (parse (third sexp)))  ]
        [(if0) (if0 (parse (second sexp)) (parse (third sexp)) (parse (fourth sexp)))]
        [else (app (parse (first sexp)) (parse (second sexp)))]
        )]
     [(symbol? sexp) (id sexp)]
     ))

;; Funciones y tipos de apoyo

(define (add-numbers l r)
  (if (and (numV? l) (numV? r))
      (numV (+ (numV-n l) (numV-n r)))
      (error "Suma de no numeros")))

(define (sub-numbers l r)
  (if (and (numV? l) (numV? r))
      (numV (- (numV-n l) (numV-n r)))
      (error "Suma de no numeros")))

(define (mult-numbers l r)
  (if (and (numV? l) (numV? r))
      (numV (* (numV-n l) (numV-n r)))
      (error "Multiplicación de no numeros")))


(define (lookup name ds)
  (type-case DefrSub ds
             [mtSub () (error 'lookup "no binding for identifier")]
             [aSub (bound-name bound-value rest-ds)
                   (if (symbol=? name bound-name)
                       bound-value
                       (lookup name rest-ds))]))

(define (num-zero? v)
  (and (numV? v) (= 0 (numV-n v))))
      
(define-type DefrSub
  [mtSub]
  [aSub (name symbol?) (value FAE-Value?) (ds DefrSub?)]
  )

(define-type FAE-Value 
  [numV (n number?)]
  [closureV (param symbol?) (body FAE?) (ds DefrSub?)]
  )

; El interprete
(define (interp sexp ds)
   (type-case FAE sexp
              [num (n) (numV n)]
              [add (l r) (add-numbers (interp l ds) (interp r ds))]
              [sub (l r) (sub-numbers (interp l ds) (interp r ds))]
              [id (v) (lookup v ds)]
              [app (fun-expr arg-expr)
                   (local ([define fun-val (interp fun-expr ds)])
                     (interp (closureV-body fun-val) 
                             (aSub (closureV-param fun-val)
                                   (interp arg-expr ds)  (closureV-ds fun-val))))
                     ]
              [fun (bound-id bound-body)
                   (closureV bound-id bound-body ds)]
              [if0 (test-cause truth falsity) 
                   (if (num-zero? (interp test-cause ds))
                       (interp truth ds) (interp falsity ds))]
              ))


(define test '{with {fac {fun {n} {if0 n 1 {* n {fac {- n 1}}}}}}
                     {fac 5}})









