;; The first three lines of this file were inserted by DrScheme. They record metadata
;; about the language level of this file in a form that our tools can easily process.
#reader(planet plai/plai:1:3/lang/reader)
(define-type FAE
   [num (n number?)]
   [add (l FAE?)
        (r FAE?)]
   [sub (l FAE?)
        (r FAE?)]
  [id (name symbol?)]
  [fun (param symbol?) (body FAE?)]
  [app (fun-expr FAE?) (arg-expr FAE?)]
  )

;; parse : sexp -> FAE
(define (parse sexp)
   (cond
     [(number? sexp) (num sexp)]
     [(list? sexp)
      (case (first sexp)
        [(+) (add (parse(second sexp))
                  (parse(third sexp)))]
        [(-) (sub (parse(second sexp))
                  (parse(third sexp)))]
        [(with) (app (fun (first (second sexp)) (parse (third sexp))) 
                      (parse (second (second sexp)))) ]
        [(fun) (fun (first (second sexp)) (parse (third sexp)))  ]
        [else (app (parse (first sexp)) (parse (second sexp)))]
        )]
     [(symbol? sexp) (id sexp)]
     ))

(define (add-numbers l r)
  (if (and (num? l) (num? r))
      (num (+ (num-n l) (num-n r)))
      (error "Suma de no numeros")))

(define (sub-numbers l r)
  (if (and (num? l) (num? r))
      (num (- (num-n l) (num-n r)))
      (error "Suma de no numeros")))


; (define (parser expr) ...
; (define (lookup name ds) ...
; (define (add-numbers l r) /* FAE + FAE -> FAE */
; (define (sub-numbers l r) /* FAE - FAE -> FAE */

(define-type DefrSub
  [mtSub]
  [aSub (name symbol?) (value FAE?) (ds DefrSub?)]
  )

;; retorna FAE
(define (lookup name ds)
  (type-case DefrSub ds
             [mtSub () (error 'lookup "no binding for identifier")]
             [aSub (bound-name bound-value rest-ds)
                   (if (symbol=? name bound-name)
                       bound-value
                       (lookup name rest-ds))]))
; El interprete
(define (interp sexp ds)
   (type-case FAE sexp
              [num (n) sexp]
              [add (l r) (add-numbers (interp l ds) (interp r ds))]
              [sub (l r) (sub-numbers (interp l ds) (interp r ds))]
              [id (v) (lookup v ds)]
              [app (fun-expr arg-expr)
                   (local ([define fun-val (interp fun-expr ds)])
                     (interp (fun-body fun-val) (aSub (fun-param fun-val)  (interp arg-expr ds)  (mtSub))))
                     ]
              [fun (bound-id bound-body)
                   sexp]
              ))


(define test '{{with {x 5} {fun {y} {+ x y}}} 7})

(interp (parse test) (mtSub))










