;; Clase Auxiliar CC41A
;; Consultas a:
;; Victor Ramiro - <vramiro@dcc.uchile.cl>

;; P1
;; duple:: Number, Symbol -> <List-of-Symbol>
(define (duple n x)
  (if (= n 0) '()
      (cons x (duple (- n 1) x))))

(duple 5 3)
(duple 2 '(ho ho))

;; P2
;; filter-in::(Symbol->Boolean), <List-of-Symbol> -> <List-of-Symbol>
(define (filter-in p ls)
  (cond
    ((null? ls) '())
    ((p (car ls)) (cons (car ls) (filter-in p (cdr ls))))
    (else (filter-in p (cdr ls)))
    ))

;; P3
(define is-number? number?)
(filter-in is-number? '(1 () 2 (a b) c))

;; P4
(define (make-tree val left rigth) (list val left rigth))
(define (value tree) (car tree))
(define (left tree) (car (cdr tree)))
(define (rigth tree) (car (cdr (cdr tree))))
(define (leave? tree) 
  (and (null? (left tree)) (null? (rigth tree))))

(define arbol (make-tree 2 '() '()))
arbol
(value arbol)
(left arbol)
(rigth arbol)
(leave? arbol)
(define arbol (make-tree 1 (make-tree 2 '() '()) (make-tree 3 '() '())))
arbol
;; P5
(define (size? tree)
  (if (null? tree)
      0
      (let ( (a (size? (left tree)))
             (b (size? (rigth tree)))
             )
        (if (> a b)
            (+ 1 a)
            (+ 1 b)
            ))))

(size? arbol)

(define (sum-up tree)
  (cond ((null? tree) 0)
        (else (+ (value tree) 
                 (sum-up (left tree))
                 (sum-up (rigth tree))))))
        
(sum-up arbol)

;; P6
;; Seg'un la auxiliar es make-bintree
;; make-bintree-n:: <List-of-Symbols> -> BinTree
(define (make-bintree-n ls)
  (letrec ((make (lambda (lst tree)
                (if (null? lst) tree
                    (make (cdr lst) (make-bintree-1 (car lst) tree)))))) 
    (make ls '())) ;; make:: <List-of-Symbol>, BinTree -> BinTree
  )

;; make-bintree-1:: Symbol, BinTree -> BinTree
(define (make-bintree-1 a bt)
  (cond
    ((null? bt) (make-tree a '() '()))
    ((< a (value bt)) (make-tree (value bt) (make-bintree-1 a (left bt)) (rigth bt)))
    (else (list (value bt) (left bt) (make-bintree-1 a (rigth bt))))
    ))

(define tree-from-list (make-bintree-n '(3 2 4 1 5)))
tree-from-list

(define (map-tree tree f)
  (cond
    ( (null? tree) '())
    ( else  (make-tree (f (value tree)) (map-tree (left tree) f) (map-tree (rigth tree) f)))))

(map-tree tree-from-list (lambda(x) (* 2 x)))