#!/usr/bin/perl

use CGI qw/:standard *table/;
use DBI;

use strict;
use warnings;

my $dbh = DBI->connect("DBI:mysql:example", "example", "example")
                or die "Couldn't connect to database: " . DBI->errstr;

print header,
	start_html('Perl CGI: Ejemplo DBI'),
	h1('Perl CGI: Ejemplo DBI');

# Si es que vienen datos
if (param()) {
	my $firstname = param('firstname');
	my $lastname = param('lastname');
	my $id = param('id');
	my $postal_code = param('postalcode');
	my $age = param('age');
	my $sex = param('sex');

	my $sth = $dbh->prepare('INSERT INTO people
				(lastname, firstname, id, postal_code, age, sex)
				VALUES
				(?,?,?,?,?,?)') or die "Couldn't prepare statement: " . $dbh->errstr;

	$sth->execute($lastname, $firstname, $id, $postal_code, $age, $sex)
            or die "Couldn't execute statement: " . $sth->errstr;

	print p,
		"Agregada una nueva persona: $firstname $lastname",
		hr;
}


# listado de usuarios
my $select = $dbh->prepare('SELECT lastname, firstname, id, postal_code, age, sex
				FROM people') or die "Couldn't select statement: " . $dbh->errstr;
$select->execute();

if ($select->rows > 0) {
	print h2("Personas en el sistema"),
		start_table({-border=>1}),
		Tr([
			th(['ID', 'Firstname','Lastname','Postal Code', 'Age', 'Sex']),
		   ]
		);

	while ( my @row = $select->fetchrow_array ) {
  		print 
		Tr([
			td([$row[2], $row[1],$row[0],$row[3], $row[4], $row[5]]),
		   ]);
	}

	print end_table;
}

print br;

print h2("Ingreso nueva persona"),
	start_form,
	"Nombre: ",textfield(-name=>'firstname'),
	br,
	"Apellido: ",textfield(-name=>'lastname'),
	br,
	"ID: ",textfield(-size=>'7', name=>'id'),
	br,
	"Postal Code: ",textfield(-size=>'5', name=>'postalcode'),
	br,
	"Edad: ",textfield(-size=>'2', name=>'age'),
	br,
	"Genero ",
	popup_menu(-name=>'sex',
		-values=>['Male','Female']),
	br,br,
	submit({value=>" Grabar Persona "}),
	end_form,
	hr;


$dbh->disconnect;
