import javax.swing.*;
import java.awt.*;
import java.util.*;

/*
 * CarRase.java
 * 
 * Created on May 19, 2003, 2:04 PM
 */

/**
 * @author Rustam M. Bunyadov Baku, Azerbaycan rustamb@risk.az R.I.S.K. Company
 * Modifyed by Javier Bustos
 */
public class CarRace extends JFrame {

    class MyTimer extends TimerTask {

        public MyTimer(CarRace listener) {
            this.listener = listener;
        }

        public void run() {
            listener.onTime();
        }

        private CarRace listener;
    }

    /** Creates new form CarRase */
    public CarRace() {
        initComponents();
    }

    public void onTime() {
        timer1OnTime();
    }


    private void initComponents() {
        timer1 = new java.util.Timer();
        timer1.schedule(new MyTimer(this), 1000, 50);
        this.setIconImage(carImage);
        jPanel1 = new javax.swing.JPanel();

        setResizable(false);
        addKeyListener(new java.awt.event.KeyAdapter() {

            public void keyPressed(java.awt.event.KeyEvent evt) {
                formKeyPressed(evt);
            }
        });

        addWindowListener(new java.awt.event.WindowAdapter() {

            public void windowClosing(java.awt.event.WindowEvent evt) {
                exitForm(evt);
            }
        });

        getContentPane().add(jPanel1, java.awt.BorderLayout.CENTER);

        pack();
    }

    private void timer1OnTime() {
        //get graphics
        g = jPanel1.getGraphics();
        //draw road
        drawRoad(roadX, roadY, roadWidth, roadHeight);
        //draw enemy car
        for (int i = 0; i <= 4; i++) {
            //move cars vertically
            enemyCarsY[i] -= enemyCarsSpeed[i] - carSpeed;
            if (enemyCarsY[i] < formDimension[1] - enemyCarHeight) {
                enemyCarsY[i] = formDimension[3] + enemyCarHeight;
            }
            if (enemyCarsY[i] > formDimension[3] + enemyCarHeight) {
                enemyCarsY[i] = formDimension[1] - enemyCarHeight;
            }
            if (enemyCarsX[i] < -enemyCarHeight) {
                enemyCarsX[i] = formDimension[2] - enemyCarHeight;
            }
            if (enemyCarsX[i] > formDimension[2] + enemyCarHeight) {
                enemyCarsX[i] = formDimension[0] - enemyCarHeight;
            }
            //move cars horizontally
            if (i == 0 || i == 2 || i == 4) {
                enemyCarsX[i]++;
            } else
                enemyCarsX[i]--;
            drawEnemyCar(enemyCarsX[i], enemyCarsY[i], enemyCarWidth, enemyCarHeight, i);
        }
        //draw drivers car
        drawCar(carX, carY, carWidth, carHeight);
        //watch for car crashes
        carCrash();
        //draw fuel speed and road information on the form
        drawPanel();
    }

    private void formKeyPressed(java.awt.event.KeyEvent evt) {
        //37 - left arrow; 38 - up arrow; 39 - right arrow; 40 - down arrow;
        // 32 - space bar
        keyCode = evt.getKeyCode();

        if (keyCode == 37 && carX > formDimension[0] && carSpeed != 0) {
            carX -= 10;
        } else if (keyCode == 38 && carY > formDimension[1]) {
            if (carSpeed < maxCarSpeed) {
                carSpeed += minCarSpeed;
            }
        } else if (keyCode == 39 && carX < formDimension[2] + formDimension[0] - carWidth && carSpeed != 0) {
            carX += 10;
        } else if (keyCode == 40 && carY < formDimension[3] + formDimension[1] - carHeight) {
            if (carSpeed > minCarSpeed) {
                carSpeed -= minCarSpeed;
            }
        } else if (keyCode == 32) {
            newGame();
        }
    }

    /** Exit the Application */
    private void exitForm(java.awt.event.WindowEvent evt) {
        System.exit(0);
    }

    public static void main(String args[]) {
        new CarRace().setVisible(true);
    }

    public Dimension getPreferredSize() {
        return frameSize;
    }

    private void drawCar(int a, int b, int c, int d) {
        roadY += carSpeed;
        if (roadY > formDimension[3]) {
            roadY = 10;
        }
        //draw sikilmish image on the car blyad!!!
        g.drawImage(carImage, a, b, c, d, null);
    }

    private void drawRoad(int a, int b, int c, int d) {
        //draw the road
        g.setColor(Color.gray);
        g.fillRect(formDimension[0], formDimension[1], formDimension[2], formDimension[3]);
        //draw the stripes on the road
        g.setColor(roadColor);
        for (int i = -6; i <= 6; i++) {
            g.fillRect(a, b + i * stripesDelay, c, d);
        }
    }

    private void drawEnemyCar(int a, int b, int c, int d, int e) {
        g.drawImage(enemyCarImage, a, b, c, d, null);
    }

    private void carCrash() {
        //oni stolknulis sikim blya
        for (int i = 0; i <= 4; i++) {
            if (enemyCarsX[i] > carX - enemyCarWidth && enemyCarsX[i] < carX + carWidth && enemyCarsY[i] > carY - enemyCarHeight && enemyCarsY[i] < carY + carWidth) {
                carSpeed = minCarSpeed;
            }
        }
        //oni stolknulis no teper uje mejdu soboy sikim blya
        for (int i = 0; i <= 4; i++) {
            for (int z = 0; z <= 4; z++) {
                if (z != i && enemyCarsX[z] > enemyCarsX[i] - enemyCarWidth && enemyCarsX[z] < enemyCarsX[i] + enemyCarWidth && enemyCarsY[z] > enemyCarsY[i] - enemyCarHeight && enemyCarsY[z] < enemyCarsY[i] + enemyCarWidth) {
                    enemyCarsX[i] = enemyCarsX[z] + enemyCarWidth;
                }
            }
        }
    }

    private void drawPanel() {
        g.setColor(panelColor);
        if (carFuel > 0) {
            carFuel--;
        } else {
            g.drawString("YOU ARE OUT OF FUEL", 50, 50);
            g.drawString("PRESS SPACE BAR TO START A NEW GAME", 50, 150);
            carSpeed = 0;
        }
        if (roadLength > 0) {
            roadLength -= carSpeed;
        } else {
            g.drawString("CONGRATULATIONS! YOU WON!!!", 50, 50);
            g.drawString("PRESS SPACE BAR TO START A NEW GAME", 50, 150);
            carSpeed = 0;
        }
        g.drawString("Speed: " + String.valueOf(carSpeed) + " mph", panelX, panelY);
        g.drawString("Fuel: " + String.valueOf(carFuel), panelX, panelY + 20);
        g.drawString("Road left: " + String.valueOf(roadLength), panelX, panelY + 40);
    }

    private void newGame() {
        //drivers car parameters
        carX = formDimension[2] / 2;
        carY = formDimension[3] - carHeight - 50;
        carSpeed = 0;
        //enemy car parameters
        carFuel = 2000;
        //road parameters
        roadX = 300;
        roadY = -roadHeight;
        roadLength = 50000;
        keyCode = 0;
    }

    private javax.swing.JPanel jPanel1;

    private java.util.Timer timer1;

    private final int[] formDimension = { 0, 0, 600, 700};

    private Graphics g = null;

    //drivers car parameters
    private final int carWidth = 40;

    private final int carHeight = 80;

    private int carX = Math.round(formDimension[2] / 2);

    private int carY = formDimension[3] - carHeight - 50;

    private int carSpeed = 0;

    private final int maxCarSpeed = 100;

    private final int minCarSpeed = 5;

    private int carFuel = 2000;

    private final Image carImage = Toolkit.getDefaultToolkit().getImage("myCar.png");

    //enemy car parameters
    private int enemyCarWidth = 40;

    private int enemyCarHeight = 80;

    private final int defaultEnemyCarWidth = 40;

    private final int defaultEnemyCarHeight = 80;

    private int[] defaultEnemyCarsX = { 400, 200, 250, 300, 350};

    private int[] enemyCarsX = { 400, 200, 250, 300, 350};

    private final int defaultEnemyCarY = formDimension[1] - enemyCarHeight - 50;

    private int[] enemyCarsY = { defaultEnemyCarY, defaultEnemyCarY, defaultEnemyCarY, defaultEnemyCarY, defaultEnemyCarY};

    private final int[] enemyCarsSpeed = { 18, 10, 25, 15, 30};

    private final Image enemyCarImage = Toolkit.getDefaultToolkit().getImage("EnemyCar.png");

    //road parameters
    private final int roadWidth = 10;

    private final int roadHeight = 40;

    private int roadX = 300;

    private int roadY = -roadHeight;

    private int roadLength = 50000;

    private final int stripesDelay = 200;

    private final Color roadColor = new Color(255, 255, 255);

    //panel parameters
    private final Color panelColor = new Color(255, 255, 255);

    private final int panelX = formDimension[2] - 150;

    private final int panelY = formDimension[3] - 50;

    private int keyCode = 0;

    private Dimension frameSize = new Dimension(formDimension[2], formDimension[3] + 20);
}
