(define (new-counter)
 (let ((val 0))
   (lambda ()
     (begin (set! val (+ 1 val)) val))))

(define (inc c) (c))


(define (new-stack)
 (let ((vals '()))

  (define (pop)
    (if (empty? vals)
        (error "cannot pop from an empty stack")
        (let ((val (car vals)))
          (set! vals (cdr vals))
          val)))

  (define (push val)
    (set! vals (cons val vals))
    val)

  (define (peek)
    (if (empty? vals)
        (error "cannot peek from an empty stack")
        (car vals)))

  (lambda (command arg)
    (cond ((eq? command 'pop) (pop))
          ((eq? command 'push) (push arg))
          ((eq? command 'peek) (peek))
          (else (error "invalid command"))))))