(define call/cc call-with-current-continuation)

(define (s-search-generator lst p?)
  (let ((success '?)) ;; placeholder for the current continuation
    (letrec ((cont-success ;; next continuation
              (lambda (x) (search lst)))
             (search
              (lambda (elem)
                (cond ((null? elem) 'done)
                      ((pair? elem) (search (car elem))
                                    (search (cdr elem)))
                      ((p? elem) (call/cc
                                  (lambda (k) ;; next search will continue from here
                                    (set! cont-success k)
                                    (success elem))))
                      (else 'done)))))
      (lambda () (call/cc 
                  (lambda (k)
                    (set! success k)
                    (cont-success 'done)))))))


(define (ss-search-generator lst p?)
  (let ((success '?)) ;; placeholder for the current continuation

    (define cont-success ;; next continuation
      (lambda (x) (search lst)))             
             
    (define search
      (lambda (elem)
        (cond ((null? elem) 'done)
              ((pair? elem) (search (car elem))
                            (search (cdr elem)))
              ((p? elem) (call/cc
                          (lambda (k) ;; next search will continue from here
                            (set! cont-success k)
                            (success elem))))
              (else 'done))))
    
      (lambda () (call/cc 
                  (lambda (k)
                    (set! success k)
                    (cont-success 'done))))))

(define (search-generator lst p?)
  (define success '?) ;; placeholder for the current continuation

  (define cont-success ;; next continuation
    (lambda (x) (search lst)))         
             
  (define search
    (lambda (elem)
      (cond ((null? elem) 'done)
            ((pair? elem) (search (car elem))
                          (search (cdr elem)))
            ((p? elem) (call/cc
                        (lambda (k) ;; next search will continue from here
                          (set! cont-success k)
                          (success elem))))
            (else 'done))))
    
  (lambda () 
    (call/cc 
     (lambda (k)
       (set! success k)
       (cont-success 'done)))))


(define tree '(0 ((1 a) 2) b (b c) (((6)))))

(define numbers (search-generator tree number?))
(numbers)
(numbers)
(numbers)
(numbers)
(numbers)
(numbers)

(define (my-char? s)
  (if (symbol? s)
      (char-alphabetic? (string-ref (symbol->string s) 0))
      #f))


(define letters (search-generator tree my-char?))
(letters)
(letters)
(letters)
(letters)
(letters)
(letters)